/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.software.SoftwareForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.Map;

public class SoftwareEditAction
extends Action2 {
    public String edit() throws Exception {
        SoftwareForm actionForm = this.getBaseForm(SoftwareForm.class);
        actionForm.setId("softwareEditForm");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        software.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            actionForm.setSoftware(software);
        }
        SelectOneLabelValueBean selectOneLabel = new SelectOneLabelValueBean(this.requestContext, "0");
        ArrayList<LabelValueBean> softwareOwnerOptions = new ArrayList<LabelValueBean>();
        softwareOwnerOptions.add(new SelectOneLabelValueBean(this.requestContext));
        softwareOwnerOptions.addAll(AdminUtils.getUserOptions(this.requestContext, software.getOwner().getId()));
        ArrayList<LabelValueBean> softwareMakers = new ArrayList<LabelValueBean>();
        softwareMakers.add(selectOneLabel);
        CompanySearch makerSearch = new CompanySearch();
        makerSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_SOFTWARE_MAKER);
        makerSearch.put("companyIdEquals", software.getManufacturerId());
        QueryCriteria makerQuery = new QueryCriteria(makerSearch);
        makerQuery.addSortColumn("company_name");
        softwareMakers.addAll(CompanyUtils.getCompanyOptions(this.requestContext, makerQuery));
        ArrayList<LabelValueBean> softwareVendors = new ArrayList<LabelValueBean>();
        softwareVendors.add(selectOneLabel);
        CompanySearch vendorSearch = new CompanySearch();
        vendorSearch.put("companyTypeEquals", AttributeFieldIds.COMPANY_TYPE_SOFTWARE_VENDOR);
        vendorSearch.put("companyIdEquals", software.getVendorId());
        QueryCriteria vendorQuery = new QueryCriteria(vendorSearch);
        vendorQuery.addSortColumn("company_name");
        softwareVendors.addAll(CompanyUtils.getCompanyOptions(this.requestContext, vendorQuery));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("software", (Object)software);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_EDIT_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.SOFTWARE_EDIT);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId()).getString());
        standardTemplate.setAttribute("softwareOwnerOptions", softwareOwnerOptions);
        standardTemplate.setAttribute("softwareTypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(software.getType()).getActiveAttrFieldOptionsCache(Attributes.SOFTWARE_TYPE));
        standardTemplate.setAttribute("softwareOsOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(software.getOs()).getActiveAttrFieldOptionsCache(Attributes.SOFTWARE_OS));
        this.request.setAttribute("manufacturersOptions", softwareMakers);
        this.request.setAttribute("vendorsOptions", softwareVendors);
        int expireYear = NumberUtils.replaceNull(actionForm.getExpireDateY(), 0);
        this.request.setAttribute("yearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, expireYear));
        this.request.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        standardTemplate.setAttribute("manufacturerHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addSoftwareMaker"));
        standardTemplate.setAttribute("vendorHelpIcon", Links.getHelpIconLink(this.requestContext, "help.addSoftwareVendor"));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.cmd.softwareEdit");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("itMgmt.softwareEdit.sectionHeader");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.SOFTWARE);
        customFieldsTemplate.setObjectId(software.getId());
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getSoftwareType());
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        SoftwareForm actionForm = this.saveActionForm(new SoftwareForm());
        Software software = new Software();
        software.setId(actionForm.getSoftwareId());
        software.setName(actionForm.getSoftwareName());
        software.setDescription(actionForm.getSoftwareDescription());
        software.setOwnerId(actionForm.getSoftwareOwner());
        software.setType(actionForm.getSoftwareType());
        software.setOs(actionForm.getSoftwarePlatform());
        software.setQuotedRetailPrice(actionForm.getRetailPrice());
        software.setQuotedOemPrice(actionForm.getOemPrice());
        software.setManufacturerId(actionForm.getManufacturerId());
        software.setVendorId(actionForm.getVendorId());
        software.setVersion(actionForm.getVersion());
        software.setExpireDateY(actionForm.getExpireDateY());
        software.setExpireDateM(actionForm.getExpireDateM());
        software.setExpireDateD(actionForm.getExpireDateD());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, software);
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        ActionMessages errors = softwareService.updateSoftware(software, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_EDIT + "?softwareId=" + software.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId());
    }
}

