/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileDeleteTemplate;
import com.kwoksys.action.files.FileEditTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.software.dto.SoftwareFile;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class SoftwareFileAction
extends Action2 {
    public String list() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        Integer softwareId = this.requestContext.getParameter("softwareId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "FILES_ORDER_BY", "file_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "FILES_ORDER", "asc");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        String fileDownloadPath = AppPaths.SOFTWARE_FILE_DOWNLOAD + "?softwareId=" + softwareId + "&fileId=";
        String fileDeletePath = AppPaths.SOFTWARE_FILE_DELETE + "?softwareId=" + softwareId + "&fileId=";
        String fileEditPath = AppPaths.SOFTWARE_FILE_EDIT + "?softwareId=" + softwareId + "&fileId=";
        boolean canDeleteFile = accessUser.hasPermission(AppPaths.SOFTWARE_FILE_DELETE);
        boolean canDownloadFile = accessUser.hasPermission(AppPaths.SOFTWARE_FILE_DOWNLOAD);
        QueryCriteria query = new QueryCriteria();
        if (FileUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(FileQueries.getOrderByColumn(orderBy), order);
        }
        List<File> files = softwareService.getSoftwareFiles(query, softwareId);
        ArrayList<String> columnHeaders = new ArrayList<String>(FileUtils.getFileColumnHeaders());
        if (canDeleteFile) {
            columnHeaders.add("command");
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        SoftwareUtils.addSoftwareHeaderCommands(this.requestContext, header, softwareId);
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (accessUser.hasPermission(AppPaths.SOFTWARE_FILE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setTitleKey("files.fileAttach");
            if (fileService.isDirectoryExist(ConfigManager.file.getSoftwareFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.SOFTWARE_FILE_ADD + "?softwareId=" + softwareId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(SoftwareUtils.getSoftwareTabs(this.requestContext, software));
        tabs.setTabActive("filesTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnPath(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnTextKey("files.colName.");
        tableTemplate.setSortableColumnHeaders(FileUtils.getSortableColumns());
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("files.noAttachments");
        if (!files.isEmpty()) {
            Counter counter = new Counter();
            for (File file : files) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(counter.incr() + ".");
                columns.add(Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), fileDownloadPath + file.getId()).getString());
                columns.add(HtmlUtils.encode(file.getTitle()));
                columns.add(file.getCreationDate());
                columns.add(FileUtils.formatFileSize(this.requestContext, file.getSize()));
                if (canDeleteFile) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Link(this.requestContext).setAjaxPath(fileEditPath + file.getId()).setTitleKey("common.action.Edit").getString());
                    sb.append(" | ");
                    sb.append(new Link(this.requestContext).setAjaxPath(fileDeletePath + file.getId()).setTitleKey("common.action.Delete").getString());
                    columns.add(sb.toString());
                }
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Integer softwareId = this.requestContext.getParameter("softwareId");
        Software software = softwareService.getSoftware(softwareId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(this.getBaseForm(FileUploadForm.class)));
        fileAdd.setFileName(this.requestContext.getParameterString("fileName0"));
        fileAdd.setFormAction(AppPaths.SOFTWARE_FILE_ADD_2 + "?softwareId=" + software.getId());
        fileAdd.setFormCancelAction(AppPaths.SOFTWARE_FILE + "?softwareId=" + software.getId());
        fileAdd.getErrorsTemplate().setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.getSoftware(softwareId);
        SoftwareFile file = new SoftwareFile(softwareId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.addFile(file, this.saveActionForm(new FileUploadForm()));
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.SOFTWARE_FILE_ADD + "?softwareId=" + softwareId + "&" + "_error=true");
        }
        softwareService.resetSoftwareFileCount(softwareId);
        return this.redirect(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
    }

    public String delete() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = softwareService.getSoftwareFile(softwareId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("softwareId", softwareId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        FileDeleteTemplate fileDelete = standardTemplate.addTemplate(new FileDeleteTemplate());
        fileDelete.setFile(file);
        fileDelete.setFormAction(AppPaths.SOFTWARE_FILE_DELETE_2 + "?softwareId=" + softwareId + "&fileId=" + fileId);
        fileDelete.setFormCancelAction(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.getSoftware(softwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = softwareService.getSoftwareFile(softwareId, fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.deleteFile(file);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId + "&" + "_error=true");
        }
        softwareService.resetSoftwareFileCount(softwareId);
        return this.ajaxUpdateView(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        try {
            SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
            Integer softwareId = this.requestContext.getParameter("softwareId");
            softwareService.getSoftware(softwareId);
            Integer fileId = this.requestContext.getParameter("fileId");
            File file = softwareService.getSoftwareFile(softwareId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }

    public String edit() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = softwareService.getSoftwareFile(softwareId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new String[]{software.getName()});
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        FileEditTemplate fileEdit = standardTemplate.addTemplate(new FileEditTemplate());
        fileEdit.setFile(file);
        fileEdit.setFormAction(AppPaths.SOFTWARE_FILE_EDIT_2 + "?softwareId=" + softwareId + "&fileId=" + fileId);
        fileEdit.setFormCancelAction(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
        ActionErrorsTemplate errorsTemplate = fileEdit.getErrorsTemplate();
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = softwareService.getSoftwareFile(software.getId(), fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.updateFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_FILE_EDIT + "?softwareId=" + software.getId() + "&fileId=" + fileId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_FILE + "?softwareId=" + softwareId);
    }
}

