/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.biz.base.BaseObjectForm;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;

public class SoftwareForm
extends BaseObjectForm {
    private Integer softwareId;
    private String softwareName;
    private String softwareDescription;
    private Integer softwareOwner;
    private Integer softwareType;
    private Integer softwarePlatform;
    private String retailPrice;
    private String oemPrice;
    private Integer manufacturerId;
    private Integer vendorId;
    private String version;
    private String expireDateY;
    private String expireDateM;
    private String expireDateD;

    @Override
    public void setRequest(RequestContext requestContext) {
        this.softwareId = requestContext.getParameterInteger("softwareId");
        this.softwareName = requestContext.getParameterString("softwareName");
        this.softwareDescription = requestContext.getParameterString("softwareDescription");
        this.softwareOwner = requestContext.getParameterInteger("softwareOwner");
        this.softwareType = requestContext.getParameterInteger("softwareType");
        this.softwarePlatform = requestContext.getParameterInteger("softwarePlatform");
        this.retailPrice = requestContext.getParameterString("retailPrice");
        this.oemPrice = requestContext.getParameterString("oemPrice");
        this.manufacturerId = requestContext.getParameterInteger("manufacturerId");
        this.vendorId = requestContext.getParameterInteger("vendorId");
        this.version = requestContext.getParameterString("version");
        this.expireDateY = requestContext.getParameterString("expireDateY");
        this.expireDateM = requestContext.getParameterString("expireDateM");
        this.expireDateD = requestContext.getParameterString("expireDateD");
    }

    public void setSoftware(Software software) {
        this.softwareName = software.getName();
        this.softwareDescription = software.getDescription();
        this.softwareOwner = software.getOwner() != null ? software.getOwner().getId() : 0;
        this.softwareType = software.getType();
        this.softwarePlatform = software.getOs();
        this.version = software.getVersion();
        this.retailPrice = software.getQuotedRetailPrice();
        this.oemPrice = software.getQuotedOemPrice();
        this.manufacturerId = software.getManufacturerId();
        this.vendorId = software.getVendorId();
        this.expireDateY = DatetimeUtils.toYearString(software.getExpireDate());
        this.expireDateM = DatetimeUtils.toMonthString(software.getExpireDate());
        this.expireDateD = DatetimeUtils.toDateString(software.getExpireDate());
    }

    public Integer getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(Integer softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareName() {
        return this.softwareName;
    }

    public String getSoftwareDescription() {
        return this.softwareDescription;
    }

    public Integer getSoftwareType() {
        return this.softwareType;
    }

    public Integer getSoftwarePlatform() {
        return this.softwarePlatform;
    }

    public String getRetailPrice() {
        return this.retailPrice;
    }

    public String getOemPrice() {
        return this.oemPrice;
    }

    public Integer getManufacturerId() {
        return this.manufacturerId;
    }

    public void setManufacturerId(Integer manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public Integer getVendorId() {
        return this.vendorId;
    }

    public Integer getSoftwareOwner() {
        return this.softwareOwner;
    }

    public String getExpireDateY() {
        return this.expireDateY;
    }

    public String getExpireDateM() {
        return this.expireDateM;
    }

    public String getExpireDateD() {
        return this.expireDateD;
    }

    public String getVersion() {
        return this.version;
    }
}

