/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.issues.IssueListTemplate;
import com.kwoksys.action.software.SoftwareIssueForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.SoftwareIssueLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;

public class SoftwareIssueAction
extends Action2 {
    public String list() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        this.getBaseForm(SoftwareIssueForm.class);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(SoftwareQueries.getOrderByColumn("creation_date"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        SoftwareUtils.addSoftwareHeaderCommands(this.requestContext, header, software.getId());
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        if (Access.hasPermission(accessUser, AppPaths.SOFTWARE_ISSUE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_ISSUE_ADD + "?softwareId=" + softwareId);
            link.setTitleKey("common.linking.linkIssue");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(SoftwareUtils.getSoftwareTabs(this.requestContext, software));
        tabs.setTabActive("issuesTab");
        IssueListTemplate listTemplate = standardTemplate.addTemplate(new IssueListTemplate());
        listTemplate.setAccessUser(accessUser);
        listTemplate.setQueryCriteria(queryCriteria);
        listTemplate.setObjectMap(new SoftwareIssueLink(softwareId).createObjectMap());
        listTemplate.setFormRemoveItemAction(AppPaths.SOFTWARE_ISSUE_REMOVE_2);
        listTemplate.setColumnHeaders(IssueUtils.getIssueColumnHeaders());
        listTemplate.setEmptyTableRowKey("issueMgmt.issueList.emptyTableMessage");
        listTemplate.getFormHiddenVariableMap().put("softwareId", String.valueOf(software.getId()));
        listTemplate.setFormRowIdName("issueId");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String remove2() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        Integer issueId = this.requestContext.getParameter("issueId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.getSoftware(softwareId);
        SoftwareIssueLink issueMap = new SoftwareIssueLink();
        issueMap.setSoftwareId(softwareId);
        issueMap.setIssueId(issueId);
        ActionMessages errors = softwareService.deleteSoftwareIssue(issueMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_ISSUE + "?softwareId=" + softwareId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_ISSUE + "?softwareId=" + softwareId);
    }
}

