/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.software.SoftwareLicenseForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.Map;

public class SoftwareLicensesAction
extends Action2 {
    public String add() throws Exception {
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        SoftwareLicenseForm actionForm = this.getBaseForm(SoftwareLicenseForm.class);
        actionForm.setId("licenseAddForm");
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        if (!actionForm.isResubmit()) {
            actionForm.setLicense(new SoftwareLicense());
            actionForm.setLicenseEntitlement("1");
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("software", (Object)software);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_LICENSE_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId()).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("software.license.addLicenseHeader");
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.SOFTWARE_LICENSE);
        customFieldsTemplate.setObjectId(actionForm.getSoftwareId());
        customFieldsTemplate.setForm(actionForm);
        customFieldsTemplate.setPartialTable(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        SoftwareLicenseForm actionForm = this.saveActionForm(new SoftwareLicenseForm());
        SoftwareLicense license = new SoftwareLicense();
        license.setSoftwareId(actionForm.getSoftwareId());
        license.setKey(actionForm.getLicenseKey());
        license.setNote(actionForm.getLicenseNote());
        license.setEntitlement(actionForm.getLicenseEntitlement());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, license);
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        ActionMessages errors = softwareService.addLicense(license, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            if (actionForm.hasCustomFields()) {
                return this.ajaxUpdateView(AppPaths.SOFTWARE_LICENSE_ADD + "?softwareId=" + license.getSoftwareId() + "&" + "_error=true");
            }
            return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + license.getSoftwareId() + "&cmd=add&" + "_error=true");
        }
        softwareService.resetSoftwareLicenseCount(license);
        return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + license.getSoftwareId());
    }

    public String delete2() throws Exception {
        SoftwareLicense license = new SoftwareLicense();
        license.setSoftwareId(this.requestContext.getParameter("softwareId"));
        license.setId(this.requestContext.getParameter("licenseId"));
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.deleteLicense(license);
        softwareService.resetSoftwareLicenseCount(license);
        return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + license.getSoftwareId());
    }

    public String edit() throws Exception {
        SoftwareLicenseForm actionForm = this.getBaseForm(SoftwareLicenseForm.class);
        actionForm.setId("licenseEditForm");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        SoftwareLicense softwareLicense = softwareService.getSoftwareLicense(actionForm.getSoftwareId(), actionForm.getLicenseId());
        if (!actionForm.isResubmit()) {
            actionForm.setLicense(softwareLicense);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("software", (Object)software);
        this.request.setAttribute("softwareLicense", (Object)softwareLicense);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_LICENSE_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId()).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("software.license.updateLicenseHeader");
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.SOFTWARE_LICENSE);
        customFieldsTemplate.setObjectId(softwareLicense.getId());
        customFieldsTemplate.setForm(actionForm);
        customFieldsTemplate.setPartialTable(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        SoftwareLicenseForm actionForm = this.saveActionForm(new SoftwareLicenseForm());
        SoftwareLicense license = new SoftwareLicense();
        license.setSoftwareId(actionForm.getSoftwareId());
        license.setId(actionForm.getLicenseId());
        license.setKey(actionForm.getLicenseKey());
        license.setNote(actionForm.getLicenseNote());
        license.setEntitlement(actionForm.getLicenseEntitlement());
        Map<Integer, Attribute> customAttributes = new AttributeManager(this.requestContext).populateCustomFieldValues(actionForm, license);
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        ActionMessages errors = softwareService.updateLicense(license, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            if (actionForm.hasCustomFields()) {
                return this.ajaxUpdateView(AppPaths.SOFTWARE_LICENSE_EDIT + "?softwareId=" + license.getSoftwareId() + "&licenseId=" + license.getId() + "&" + "_error=true");
            }
            return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + license.getSoftwareId() + "&licenseId=" + license.getId() + "&cmd=edit&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + license.getSoftwareId());
    }
}

