/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SoftwareListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        SoftwareSearchForm actionForm = this.getSessionBaseForm(SoftwareSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "SOFTWARE_ORDER_BY", "software_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "SOFTWARE_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("SOFTWARE_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "SOFTWARE_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getSoftwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        SoftwareSearch softwareSearch = new SoftwareSearch(this.requestContext, "SOFTWARE_SEARCH_CRITERIA_MAP");
        softwareSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(softwareSearch);
        query.setLimit(rowLimit, rowStart);
        if (SoftwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(SoftwareQueries.getOrderByColumn(orderBy), order);
        }
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        int rowCount = softwareService.getSoftwareCount(query);
        ArrayList<LabelValueBean> manufacturerOptions = new ArrayList<LabelValueBean>();
        manufacturerOptions.add(new SelectOneLabelValueBean(this.requestContext));
        QueryCriteria filterQuery = new QueryCriteria();
        filterQuery.addSortColumn(SoftwareQueries.getOrderByColumn("software_manufacturer"));
        for (Map<String, String> software : softwareService.getSoftwareCountGroupByCompany(filterQuery)) {
            String softwareCount = software.get("software_count");
            String manufacturerId = software.get("manufacturer_company_id");
            String manufacturerName = software.get("software_manufacturer");
            if (manufacturerName == null) continue;
            manufacturerOptions.add(new LabelValueBean(manufacturerName + " (" + softwareCount + ")", manufacturerId));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("manufacturerIdOptions", manufacturerOptions);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_LIST);
        if (!softwareSearch.getSearchCriteriaMap().isEmpty()) {
            this.request.setAttribute("searchResultText", (Object)Localizer.getText(this.requestContext, "itMgmt.softwareList.searchResult"));
        }
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(SoftwareUtils.getColumnHeaderList());
        tableTemplate.setSortableColumnHeaders(SoftwareUtils.getSortableColumns());
        tableTemplate.setColumnPath(AppPaths.SOFTWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("itMgmt.softwareList.emptyTableMessage");
        if (rowCount != 0) {
            List<Software> softwareList = softwareService.getSoftwareList(query);
            List<DataRow> dataList = SoftwareUtils.formatSoftwareList(this.requestContext, softwareList, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "itMgmt.softwareList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.SOFTWARE_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.SOFTWARE_LIST + "?rowStart=");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.softwareList.title");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.SOFTWARE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_ADD);
            link.setTitleKey("itMgmt.cmd.softwareAdd");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.SOFTWARE_LIST_EXPORT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.SOFTWARE_LIST_EXPORT);
            link.setTitleKey("itMgmt.cmd.softwareListExport");
            link.setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

