/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Map;

public class SoftwareSearchTemplate
extends BaseTemplate {
    private String formAction;
    private boolean hideSearchButton;
    private String clearSearchLink;

    public SoftwareSearchTemplate() {
        super(SoftwareSearchTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        ArrayList<LabelValueBean> manufacturerOptions = new ArrayList<LabelValueBean>();
        manufacturerOptions.add(new SelectOneLabelValueBean(this.requestContext));
        QueryCriteria softQuery = new QueryCriteria();
        softQuery.addSortColumn(SoftwareQueries.getOrderByColumn("software_manufacturer"));
        for (Map<String, String> software : softwareService.getSoftwareCountGroupByCompany(softQuery)) {
            String manufacturerId = software.get("manufacturer_company_id");
            String manufacturerName = software.get("software_manufacturer");
            if (manufacturerName == null) continue;
            manufacturerOptions.add(new LabelValueBean(manufacturerName.toString(), manufacturerId.toString()));
        }
        this.request.setAttribute("formGetSoftwareAction", (Object)(AppPaths.ROOT + AppPaths.IT_MGMT_AJAX_GET_SOFTWARE_BY_MAKER + "?manufacturerId="));
        this.request.setAttribute("manufacturerOptions", manufacturerOptions);
        this.request.setAttribute("softwareTypeOptions", new AttributeManager(this.requestContext).getAttrFieldOptionsCache(Attributes.SOFTWARE_TYPE));
        this.request.setAttribute("customFieldsOptions", new AttributeManager(this.requestContext).getCustomFieldOptions(ObjectTypes.SOFTWARE));
        if (!this.hideSearchButton) {
            this.clearSearchLink = new Link(this.requestContext).setAppPath(AppPaths.SOFTWARE_INDEX + "?cmd=clear").setTitleKey("common.form.clearCriteria").getString();
        }
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public boolean getHideSearchButton() {
        return this.hideSearchButton;
    }

    public void setHideSearchButton(boolean hideSearchButton) {
        this.hideSearchButton = hideSearchButton;
    }

    public String getClearSearchLink() {
        return this.clearSearchLink;
    }
}

