/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contracts.dao.ContractQueries;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.Callback;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class SoftwareSpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private Software software;
    private boolean populateLinkedContract;
    private List<String> linkedContracts;

    public SoftwareSpecTemplate(Software software) {
        super(SoftwareSpecTemplate.class);
        this.software = software;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        this.detailTableTemplate.setNumColumns(2);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_id");
        td.setValue(String.valueOf(this.software.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_name");
        td.setValue(HtmlUtils.encode(this.software.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_version");
        td.setValue(HtmlUtils.encode(this.software.getVersion()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_expire_date");
        td.setValue(DatetimeUtils.toShortDate(this.software.getExpireDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.software.getDescription()));
        boolean canViewPage = Access.hasPermission(accessUser, AppPaths.SOFTWARE_DETAIL);
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_owner");
        td.setValue(Links.getUserIconLink(this.requestContext, this.software.getOwner(), canViewPage, true).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_manufacturer");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.software.getManufacturerName(), this.software.getManufacturerId()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_vendor");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.software.getVendorName(), this.software.getVendorId()).getString());
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        AttributeField attrFieldType = attributeManager.getAttrFieldMapCache(Attributes.SOFTWARE_TYPE).get(this.software.getType());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_type");
        td.setValue(Links.getAttrFieldIcon(this.requestContext, attrFieldType).getString());
        AttributeField attrFieldOS = attributeManager.getAttrFieldMapCache(Attributes.SOFTWARE_OS).get(this.software.getOs());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_platform");
        td.setValue(Links.getAttrFieldIcon(this.requestContext, attrFieldOS).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_quoted_retail_price");
        td.setValue(HtmlUtils.encode(this.software.getQuotedRetailPrice()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.software_quoted_oem_price");
        td.setValue(HtmlUtils.encode(this.software.getQuotedOemPrice()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.license_purchased");
        td.setValue(Localizer.getText(this.requestContext, "itMgmt.softwareDetail.numberOfLicenses", new Object[]{this.software.getLicensePurchased()}));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.license_installed");
        td.setValue(Localizer.getText(this.requestContext, "itMgmt.softwareDetail.numberOfLicenses", new Object[]{this.software.getLicenseInstalled()}));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.license_available");
        Object[] object3 = new Object[]{this.software.getLicenseAvailable()};
        if (Software.isEnoughLicenses(this.software.getLicenseAvailable())) {
            td.setValue(Localizer.getText(this.requestContext, "itMgmt.softwareDetail.numberOfLicenses", object3));
        } else {
            td.setValue(Localizer.getText(this.requestContext, "itMgmt.softwareDetail.numberOfNeedLicenses", object3));
        }
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.software.getCreationDate(), this.software.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.software.getModificationDate(), this.software.getModifier()));
        if (this.populateLinkedContract) {
            final boolean canViewContract = Access.hasPermission(accessUser, AppPaths.CONTRACTS_DETAIL);
            this.linkedContracts = new ArrayList<String>();
            SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
            QueryCriteria queryCriteria = new QueryCriteria();
            queryCriteria.addSortColumn(ContractQueries.getOrderByColumn("contract_name"));
            queryCriteria.setCallback(new Callback(){

                @Override
                public void run(Object object) throws Exception {
                    Contract contract = (Contract)object;
                    Link link = new Link(SoftwareSpecTemplate.this.requestContext);
                    link.setTitle(contract.getName());
                    if (canViewContract) {
                        link.setAjaxPath(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
                    }
                    SoftwareSpecTemplate.this.linkedContracts.add(link.getString());
                }
            });
            softwareService.fetchSoftwareContracts(queryCriteria, this.software.getId());
        }
    }

    @Override
    public String getJspPath() {
        return "/jsp/software/SoftwareSpecTemplate.jsp";
    }

    public String getHeaderText() {
        return Localizer.getText(this.requestContext, "itMgmt.softwareDetail.header", (Object[])new String[]{this.software.getName()});
    }

    public List<String> getLinkedContracts() {
        return this.linkedContracts;
    }

    public void setPopulateLinkedContract(boolean populateLinkedContract) {
        this.populateLinkedContract = populateLinkedContract;
    }
}

