/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.userpreference;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contacts.ContactForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;

public class ContactEditAction
extends Action2 {
    public String edit() throws Exception {
        ContactForm actionForm = this.getBaseForm(ContactForm.class);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Contact contact = contactService.getOptionalContact(this.requestContext.getUser().getContactId());
        if (!actionForm.isResubmit()) {
            actionForm.setContact(contact);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.USER_PREF_CONTACT_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.USER_PREF_INDEX).getString());
        standardTemplate.setAttribute("messenger1TypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contact.getMessenger1Type()).getActiveAttrFieldOptionsCache(Attributes.CONTACT_IM));
        standardTemplate.setAttribute("messenger2TypeOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(contact.getMessenger2Type()).getActiveAttrFieldOptionsCache(Attributes.CONTACT_IM));
        standardTemplate.setAttribute("contact", contact);
        standardTemplate.setAttribute("contactId", contact.getId().equals(0) ? Localizer.getText(this.requestContext, "form.autoId") : contact.getId());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("userPref.contactEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("contactMgmt.contactEdit.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        ContactForm actionForm = this.saveActionForm(new ContactForm());
        Contact contact = contactService.getOptionalContact(accessUser.getContactId());
        contact.setTitle(actionForm.getContactTitle());
        contact.setPhoneHome(actionForm.getContactPhoneHome());
        contact.setPhoneMobile(actionForm.getContactPhoneMobile());
        contact.setPhoneWork(actionForm.getContactPhoneWork());
        contact.setFax(actionForm.getContactFax());
        contact.setEmailSecondary(actionForm.getContactEmailSecondary());
        contact.setMessenger1Id(actionForm.getMessenger1Id());
        contact.setMessenger1Type(actionForm.getMessenger1Type());
        contact.setMessenger2Id(actionForm.getMessenger2Id());
        contact.setMessenger2Type(actionForm.getMessenger2Type());
        contact.setHomepageUrl(actionForm.getContactHomepageUrl());
        contact.setAddressStreetPrimary(actionForm.getAddressStreet());
        contact.setAddressCityPrimary(actionForm.getAddressCity());
        contact.setAddressStatePrimary(actionForm.getAddressState());
        contact.setAddressZipcodePrimary(actionForm.getAddressZipcode());
        contact.setAddressCountryPrimary(actionForm.getAddressCountry());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.updateUserContact(accessUser, contact);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.USER_PREF_CONTACT_EDIT + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.USER_PREF_INDEX);
    }
}

