/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.userpreference;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Contact contact = contactService.getOptionalContact(user.getContactId());
        ArrayList<Link> linkList = new ArrayList<Link>();
        if (user.hasPermission(AppPaths.USER_PREF_PASSWORD_EDIT) && adminService.allowPasswordUpdate()) {
            linkList.add(new Link(this.requestContext).setAjaxPath(AppPaths.USER_PREF_PASSWORD_EDIT).setTitleKey("userPref.passwordEdit.title"));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("linkList", linkList);
        if (user.hasPermission(AppPaths.USER_PREF_CONTACT_EDIT)) {
            standardTemplate.setAttribute("prefEditPath", new Link(this.requestContext).setAjaxPath(AppPaths.USER_PREF_CONTACT_EDIT).setTitleKey("common.action.Edit").getString());
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("userPref.index.header");
        standardTemplate.addTemplate(AdminUtils.formatUserContact(contact, this.requestContext, false));
        return standardTemplate.findTemplate("standard_template");
    }
}

