/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dao.AccessGroupDao;
import com.kwoksys.biz.admin.dao.AccessUserDao;
import com.kwoksys.biz.admin.dao.AdminDao;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dao.AttributeDao;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.admin.dto.DbSequence;
import com.kwoksys.biz.admin.dto.GroupPermissionMap;
import com.kwoksys.biz.admin.dto.Icon;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.admin.dto.UserPermissionMap;
import com.kwoksys.biz.auth.core.AuthUtils;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdminService {
    private RequestContext requestContext;

    public AdminService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Map<String, String>> getDatabases() throws DatabaseException {
        return new AdminDao(this.requestContext).getDatabases();
    }

    public List<DbSequence> getDbSequences() throws DatabaseException {
        return new AdminDao(this.requestContext).getDbSequences();
    }

    public ActionMessages updateConfig(List<SystemConfig> list) throws DatabaseException {
        ActionMessages errors = new AdminDao(this.requestContext).updateConfig(list);
        if (errors.isEmpty()) {
            this.resetSystemCacheConfig();
        }
        return errors;
    }

    private ActionMessages resetSystemCacheConfig() throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(new SystemConfig("system.cacheKey", String.valueOf(systemService.getSystemInfo().getSysdate().getTime())));
        return new AdminDao(this.requestContext).updateConfig(list);
    }

    public Map<Integer, AttributeGroup> getAttributeGroups(Integer objectTypeId) throws DatabaseException {
        return new AttributeDao(this.requestContext).getAttributeGroups(objectTypeId);
    }

    public AttributeGroup getAttributeGroup(Integer attributeGroupId, Integer objectTypeId) throws DatabaseException, ObjectNotFoundException {
        return new AttributeDao(this.requestContext).getAttributeGroup(attributeGroupId, objectTypeId);
    }

    public Map<Integer, Attribute> getAttributes(QueryCriteria query) throws DatabaseException {
        return new AttributeDao(this.requestContext).getAttributeList(query);
    }

    public boolean hasCustomFields(Integer objectTypeId) throws DatabaseException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("isCustomAttr", true);
        attributeSearch.put("objectTypeId", objectTypeId);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        return new AttributeDao(this.requestContext).hasCustomFields(query);
    }

    public Attribute getSystemAttribute(Integer attributeId) throws DatabaseException, ObjectNotFoundException {
        Attribute attr = new AttributeDao(this.requestContext).getAttribute(attributeId);
        if (attr.isCustomAttr() || !attr.isAttrFieldsEditable()) {
            throw new ObjectNotFoundException();
        }
        return attr;
    }

    public Attribute getCustomAttribute(Integer attributeId) throws DatabaseException, ObjectNotFoundException {
        AttributeDao attrDao = new AttributeDao(this.requestContext);
        Attribute attr = attrDao.getAttribute(attributeId);
        if (!attr.isCustomAttr()) {
            throw new ObjectNotFoundException();
        }
        return attr;
    }

    public Map<Integer, AttributeField> getEditAttributeFields(QueryCriteria query) throws DatabaseException {
        return new AttributeDao(this.requestContext).getAttributeFields(query);
    }

    public Map<Integer, AttributeField> getAttributeFields(Integer attributeId) throws DatabaseException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("attributeIdEquals", attributeId);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn("attribute_field_name"));
        return new AttributeDao(this.requestContext).getAttributeFields(query);
    }

    public AttributeField getAttributeField(Integer attrFieldId) throws DatabaseException, ObjectNotFoundException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("isEditable", true);
        return new AttributeDao(this.requestContext).getAttributeField(new QueryCriteria(attributeSearch), attrFieldId);
    }

    public Map<Integer, Object> getCustomAttributeValueMap(Integer objectTypeId, Integer objectId) throws DatabaseException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("objectTypeId", objectTypeId);
        attributeSearch.put("objectId", objectId);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn("attribute_name"));
        return new AttributeDao(this.requestContext).getCustomAttributeValueMap(query);
    }

    public List<Integer> getSavedAttributeFieldTypes(Integer attrFieldId) throws DatabaseException {
        if (attrFieldId == null || attrFieldId == 0) {
            return new ArrayList<Integer>();
        }
        return new AttributeDao(this.requestContext).getSavedAttributeFieldTypes(new QueryCriteria(), attrFieldId);
    }

    public Set<Integer> getAttributeFieldTypesByField(Integer attrFieldId) throws DatabaseException {
        if (attrFieldId == null || attrFieldId == 0) {
            return new HashSet<Integer>();
        }
        return new AttributeDao(this.requestContext).getAttributeFieldTypesByField(new QueryCriteria(), attrFieldId);
    }

    public ActionMessages addAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (attributeGroup.getName().isEmpty()) {
            errors.add("attrGroupName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "admin.attribute.attribute_group_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).addAttributeGroup(attributeGroup);
    }

    public ActionMessages updateAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (attributeGroup.getName().isEmpty()) {
            errors.add("attrGroupName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "admin.attribute.attribute_group_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).updateAttributeGroup(attributeGroup);
    }

    public ActionMessages deleteAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        return new AttributeDao(this.requestContext).deleteAttributeGroup(attributeGroup);
    }

    public ActionMessages addAttribute(Attribute attr) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("attrName").setTitleKey("admin.attribute.attribute_name").setNullable(false).calculateLength(attr.getName()));
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).addCustomAttribute(attr);
    }

    public ActionMessages updateAttribute(Attribute attr) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("attrName").setTitleKey("admin.attribute.attribute_name").setNullable(false).calculateLength(attr.getName()));
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).updateCustomAttribute(attr);
    }

    public ActionMessages updateSystemAttribute(Attribute attr) throws DatabaseException {
        return new AttributeDao(this.requestContext).updateSystemAttribute(attr);
    }

    public ActionMessages deleteAttribute(Attribute attr) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).deleteAttribute(attr);
    }

    public ActionMessages addAttributeField(AttributeField attrField) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (attrField.getName().isEmpty()) {
            errors.add("attributeFieldName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "admin.attribute.attribute_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).addAttributeField(attrField);
    }

    public ActionMessages updateAttributeField(AttributeField attrField) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (attrField.getName().isEmpty()) {
            errors.add("attributeFieldName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "admin.attribute.attribute_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AttributeDao(this.requestContext).updateAttributeField(attrField);
    }

    public List<Icon> getIcons(Integer attributeId) throws DatabaseException {
        return new AttributeDao(this.requestContext).getIcons(attributeId);
    }

    public List<AccessGroup> getGroups(QueryCriteria query) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).getGroups(query);
    }

    public AccessGroup getGroup(Integer groupId) throws DatabaseException, ObjectNotFoundException {
        return new AccessGroupDao(this.requestContext).getGroup(groupId);
    }

    public ActionMessages addGroup(AccessGroup group) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (group.getName().isEmpty()) {
            errors.add("groupName", new ActionMessage("admin.groupEdit.error.groupName"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessGroupDao(this.requestContext).addGroup(group);
    }

    public ActionMessages updateGroup(AccessGroup group) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (group.getName().isEmpty()) {
            errors.add("groupName", new ActionMessage("admin.groupEdit.error.groupName"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessGroupDao(this.requestContext).editGroup(group);
    }

    public ActionMessages deleteGroup(AccessGroup group) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).deleteGroup(group);
    }

    public List<GroupPermissionMap> getGroupAccess(QueryCriteria query, Integer groupId) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).getGroupAccess(query, groupId);
    }

    public ActionMessages updateGroupAccess(GroupPermissionMap groupperm) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).updateGroupAccess(groupperm);
    }

    public List<AccessUser> getAvailableMembers(Integer groupId) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).getAvailableMembers(groupId);
    }

    public List<AccessUser> getGroupMembers(Integer groupId) throws DatabaseException {
        return new AccessGroupDao(this.requestContext).getGroupMembers(groupId);
    }

    public List<AccessUser> getUsers(QueryCriteria query) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getUsers(query);
    }

    public List<AccessUser> getExtendedUsers(QueryCriteria query) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getExtendedUsers(query);
    }

    public int getUserCount(QueryCriteria query) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getUserCount(query);
    }

    public AccessUser getUser(Integer userId) throws DatabaseException, ObjectNotFoundException {
        return new AccessUserDao(this.requestContext).getUser(userId);
    }

    public Integer getUserIdByUsername(String username) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getUserIdByUsername(username);
    }

    public Integer getUserIdByEmail(String email) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getUserIdByEmail(email);
    }

    public List<UserPermissionMap> getUserAccess(QueryCriteria query, Integer userId) throws DatabaseException {
        return new AccessUserDao(this.requestContext).getUserAccess(query, userId);
    }

    public ActionMessages addUser(AccessUser user, AccessGroup group, Contact contact, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = this.validateUser(user, contact, customAttributes);
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validatePassword("common.column.user_password", user);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessUserDao(this.requestContext).addUser(user, group, contact);
    }

    public ActionMessages updateUser(AccessUser user, AccessGroup group, Contact contact, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = this.validateUser(user, contact, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessUserDao(this.requestContext).updateUser(user, group, contact);
    }

    public ActionMessages validateUser(AccessUser user, Contact contact, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isEmpty(user.getUsername())) {
            errors.add("username", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.username")));
        } else {
            Integer queryUserId = this.getUserIdByUsername(user.getUsername());
            if (queryUserId != null && !queryUserId.equals(user.getId())) {
                errors.add("usernameInUse", new ActionMessage("admin.userEdit.error.usernameInUse"));
            }
        }
        if (StringUtils.isEmpty(user.getEmail())) {
            errors.add("email", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.user_email")));
        }
        InputValidator validator = new InputValidator(this.requestContext, errors);
        this.validateContactInputs(validator, errors, contact);
        validator.validate(new ColumnField().setName("displayName").setTitleKey("common.column.user_display_name").calculateLength(user.getDisplayName()).setColumnName("access_user.display_name").setNullable(false));
        validator.validate(new ColumnField().setName("firstName").setTitleKey("common.column.contact_first_name").calculateLength(user.getFirstName()).setColumnName("contact.first_name").setNullable(false));
        validator.validate(new ColumnField().setName("lastName").setTitleKey("common.column.contact_last_name").calculateLength(user.getLastName()).setColumnName("contact.last_name").setNullable(false));
        validator.validateAttrs(user, customAttributes);
        return errors;
    }

    public ActionMessages updateUserContact(AccessUser user, Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        this.validateContactInputs(new InputValidator(this.requestContext, errors), errors, contact);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessUserDao(this.requestContext).updateUserContact(user, contact);
    }

    private void validateContactInputs(InputValidator validator, ActionMessages errors, Contact contact) {
        if (contact != null) {
            if (contact.getMessenger1Type() != 0 && StringUtils.isEmpty(contact.getMessenger1Id()) || contact.getMessenger1Type() == 0 && !StringUtils.isEmpty(contact.getMessenger1Id()) || contact.getMessenger2Type() != 0 && StringUtils.isEmpty(contact.getMessenger2Id()) || contact.getMessenger2Type() == 0 && !StringUtils.isEmpty(contact.getMessenger2Id())) {
                errors.add("invalidMessengerInput", new ActionMessage("admin.userEdit.error.invalidMessengerInput"));
            } else {
                validator.validate(new ColumnField().setName("im1").setTitleKey("common.column.contact_im").calculateLength(contact.getMessenger1Id()).setColumnName("contact.messenger_1_id"));
                validator.validate(new ColumnField().setName("im2").setTitleKey("common.column.contact_im").calculateLength(contact.getMessenger2Id()).setColumnName("contact.messenger_2_id"));
            }
            validator.validate(new ColumnField().setName("contactHomePhone").setTitleKey("common.column.contact_phone_home").calculateLength(contact.getPhoneHome()).setColumnName("contact.contact_phone_home"));
            validator.validate(new ColumnField().setName("contactMobilePhone").setTitleKey("common.column.contact_phone_mobile").calculateLength(contact.getPhoneMobile()).setColumnName("contact.contact_phone_mobile"));
            validator.validate(new ColumnField().setName("contactWorkPhone").setTitleKey("common.column.contact_phone_work").calculateLength(contact.getPhoneWork()).setColumnName("contact.contact_phone_work"));
            validator.validate(new ColumnField().setName("contactFax").setTitleKey("common.column.contact_fax").calculateLength(contact.getFax()).setColumnName("contact.contact_fax"));
            validator.validate(new ColumnField().setName("emailPrimary").setTitleKey("common.column.contact_main_email").calculateLength(contact.getEmailPrimary()).setColumnName("contact.contact_email_primary"));
            validator.validate(new ColumnField().setName("emailAlternate").setTitleKey("common.column.contact_email_secondary").calculateLength(contact.getEmailSecondary()).setColumnName("contact.contact_email_secondary"));
            validator.validate(new ColumnField().setName("addressStreet").setTitleKey("common.column.contact_address_street_primary").calculateLength(contact.getAddressStreetPrimary()).setColumnName("contact.address_street_primary"));
            validator.validate(new ColumnField().setName("addressCity").setTitleKey("common.column.contact_address_city_primary").calculateLength(contact.getAddressCityPrimary()).setColumnName("contact.address_city_primary"));
            validator.validate(new ColumnField().setName("addressState").setTitleKey("common.column.contact_address_state_primary").calculateLength(contact.getAddressStatePrimary()).setColumnName("contact.address_state_primary"));
        }
    }

    public ActionMessages updateUserPassword(AccessUser accessUser) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("password").setNullable(false).calculateLength(accessUser.getRequestedPassword()).setTitleKey("userPref.passwordEdit.passwordOld"));
        if (StringUtils.isEmpty(accessUser.getPasswordNew())) {
            errors.add("password", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "admin.userPasswordReset.passwordNew")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        try {
            if (!AuthUtils.hashPassword(accessUser.getRequestedPassword()).equals(accessUser.getHashedPassword())) {
                errors.add("oldPasswordMismatch", new ActionMessage("userPref.passwordEdit.error.oldPasswordMismatch"));
            }
        }
        catch (Exception e) {
            errors.add("application", new ActionMessage("common.error.application"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return this.resetUserPassword(accessUser);
    }

    public ActionMessages resetUserPassword(AccessUser user) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator inputValidator = new InputValidator(this.requestContext, errors);
        inputValidator.validatePassword("admin.userPasswordReset.passwordNew", user);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new AccessUserDao(this.requestContext).editUserPassword(user);
    }

    public ActionMessages deleteUser(AccessUser user) throws DatabaseException {
        return new AccessUserDao(this.requestContext).deleteUser(user);
    }

    public ActionMessages updateUserAccess(UserPermissionMap userperm) throws DatabaseException {
        return new AccessUserDao(this.requestContext).updateUserAccess(userperm);
    }

    public boolean allowPasswordUpdate() {
        return !ConfigManager.auth.getAuthMethod().equals("ldap");
    }
}

