/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.List;

public class AdminTabs {
    public static final String GROUP_ACCESS_TAB = "accessTab";
    public static final String GROUP_MEMBERS_TAB = "membersTab";
    public static final String USER_ACCESS_TAB = "accessTab";
    public static final String USER_CONACT_TAB = "contactTab";
    public static final String USER_HARDWARE_TAB = "hardwareTab";

    public static List<Link> createGroupTabs(RequestContext requestContext, Integer groupId) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> links = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.ADMIN_GROUP_DETAIL)) {
            links.add(new Link(requestContext).setName(GROUP_MEMBERS_TAB).setAjaxPath(AppPaths.ADMIN_GROUP_DETAIL + "?groupId=" + groupId).setTitleKey("admin.groupDetail.membersTab"));
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_GROUP_ACCESS)) {
            links.add(new Link(requestContext).setName("accessTab").setAjaxPath(AppPaths.ADMIN_GROUP_ACCESS + "?groupId=" + groupId).setTitleKey("admin.groupDetail.accessTab"));
        }
        return links;
    }

    public static List<Link> createUserTabs(RequestContext requestContext, AccessUser appUser) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> links = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL)) {
            links.add(new Link(requestContext).setName(USER_CONACT_TAB).setAjaxPath(AppPaths.ADMIN_USER_DETAIL + "?userId=" + appUser.getId()).setTitleKey("admin.user.tab.contact"));
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_ACCESS)) {
            links.add(new Link(requestContext).setName("accessTab").setAjaxPath(AppPaths.ADMIN_USER_ACCESS + "?userId=" + appUser.getId()).setTitleKey("admin.cmd.userAccess"));
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_HARDWARE)) {
            links.add(new Link(requestContext).setName(USER_HARDWARE_TAB).setAjaxPath(AppPaths.ADMIN_USER_HARDWARE + "?userId=" + appUser.getId()).setTitle(Localizer.getText(requestContext, "admin.user.tab.hardware", new Object[]{appUser.getHardwareCount()})));
        }
        return links;
    }
}

