/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdminUtils {
    public static final String ADMIN_APP_CMD = "app";
    public static final String ADMIN_APP_EDIT_CMD = "appEdit";
    public static final String ADMIN_APP_EDIT_2_CMD = "appEdit2";
    public static final String ADMIN_AUTH_CMD = "auth";
    public static final String ADMIN_AUTH_EDIT_CMD = "authEdit";
    public static final String ADMIN_AUTH_EDIT_2_CMD = "authEdit2";
    public static final String ADMIN_DB_BACKUP_CMD = "backup";
    public static final String ADMIN_DB_BACKUP_EDIT_CMD = "backupEdit";
    public static final String ADMIN_DB_BACKUP_EDIT_2_CMD = "backupEdit2";
    public static final String ADMIN_DB_BACKUP_EXECUTE = "backupExecute";
    public static final String ADMIN_COMPANY_CMD = "company";
    public static final String ADMIN_COMPANY_EDIT_CMD = "companyEdit";
    public static final String ADMIN_COMPANY_EDIT_2_CMD = "companyEdit2";
    public static final String ADMIN_DB_SEQUENCES_CMD = "dbSequences";
    public static final String ADMIN_EMAIL_CMD = "email";
    public static final String ADMIN_EMAIL_SMTP_EDIT_CMD = "emailEdit";
    public static final String ADMIN_EMAIL_SMTP_EDIT_2_CMD = "emailEdit2";
    public static final String ADMIN_EMAIL_POP_EDIT_CMD = "popEmailEdit";
    public static final String ADMIN_EMAIL_POP_EDIT_2_CMD = "popEmailEdit2";
    public static final String ADMIN_FILE_CMD = "file";
    public static final String ADMIN_FILE_EDIT_CMD = "fileEdit";
    public static final String ADMIN_FILE_EDIT_2_CMD = "fileEdit2";
    public static final String ADMIN_LDAP_TEST_CMD = "ldapTest";
    public static final String ADMIN_LDAP_TEST_2_CMD = "ldapTest2";
    public static final String ADMIN_LOOK_FEEL_CMD = "look";
    public static final String ADMIN_LOOK_FEEL_EDIT_CMD = "lookEdit";
    public static final String ADMIN_LOOK_FEEL_EDIT_2_CMD = "lookEdit2";
    public static final String ADMIN_LOGGING_EDIT_CMD = "loggingEdit";
    public static final String ADMIN_LOGGING_EDIT_2_CMD = "loggingEdit2";
    public static final String ADMIN_REPORTS_EDIT_CMD = "reportsEdit";
    public static final String ADMIN_REPORTS_EDIT_2_CMD = "reportsEdit2";
    public static final String ADMIN_RSS_EDIT_CMD = "rssEdit";
    public static final String ADMIN_RSS_EDIT_2_CMD = "rssEdit2";
    public static final String ADMIN_SYSTEM_INFO_CMD = "system";
    public static final String ADMIN_RELOAD_LOCALIZER_CMD = "reloadLocalizer";
    public static final String ADMIN_RUN_TESTS_CMD = "runTests";
    public static final String USER_DISPLAY_NAME = "user_display_name";
    public static final String USER_USERNAME = "username";
    static final Map<Integer, Integer> objectTypeMap = new HashMap<Integer, Integer>();

    public static boolean isAttributeTypeMappingEnabled(Integer attrId) {
        if (attrId == null) {
            return false;
        }
        return objectTypeMap.containsValue(attrId);
    }

    public static DetailTableTemplate formatUserContact(Contact contact, RequestContext requestContext, boolean showAdminNotes) throws DatabaseException {
        DetailTableTemplate template = new DetailTableTemplate();
        template.setNumColumns(2);
        DetailTableTemplate.Td td = template.newTd();
        td.setHeaderKey("common.column.contact_id");
        td.setValue(contact.getId() == 0 ? "" : String.valueOf(contact.getId()));
        td = template.newTd();
        td.setHeaderKey("common.column.company_name");
        td.setValue(Links.getCompanyDetailsLink(requestContext, contact.getCompanyName(), contact.getCompanyId()).getString());
        td = template.newTd();
        td.setHeaderKey("common.column.contact_title");
        td.setValue(HtmlUtils.encode(contact.getTitle()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_phone_work");
        td.setValue(HtmlUtils.encode(contact.getPhoneWork()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_phone_home");
        td.setValue(HtmlUtils.encode(contact.getPhoneHome()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_phone_mobile");
        td.setValue(HtmlUtils.encode(contact.getPhoneMobile()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_fax");
        td.setValue(HtmlUtils.encode(contact.getFax()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_address_street_primary");
        td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getAddressStreetPrimary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_address_city_primary");
        td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getAddressCityPrimary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_address_state_primary");
        td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getAddressStatePrimary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_address_zipcode_primary");
        td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getAddressZipcodePrimary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_address_country_primary");
        td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getAddressCountryPrimary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_email_secondary");
        td.setValue(HtmlUtils.formatMailtoLink(contact.getEmailSecondary()));
        td = template.newTd();
        td.setHeaderKey("common.column.contact_homepage_url");
        td.setValue(HtmlUtils.formatExternalLink(requestContext, contact.getHomepageUrl()));
        td = template.newTd();
        if (contact.getMessenger1TypeAttribute(requestContext).isEmpty()) {
            td.setHeaderKey("common.column.contact_im");
        } else {
            td.setHeaderText(Localizer.getText(requestContext, "common.column.contact_im_not_null", new Object[]{HtmlUtils.encode(contact.getMessenger1TypeAttribute(requestContext))}));
        }
        td.setValue(HtmlUtils.encode(contact.getMessenger1Id()));
        td = template.newTd();
        if (contact.getMessenger2TypeAttribute(requestContext).isEmpty()) {
            td.setHeaderKey("common.column.contact_im");
        } else {
            td.setHeaderText(Localizer.getText(requestContext, "common.column.contact_im_not_null", new Object[]{HtmlUtils.encode(contact.getMessenger2TypeAttribute(requestContext))}));
        }
        td.setValue(HtmlUtils.encode(contact.getMessenger2Id()));
        if (showAdminNotes) {
            td = template.newTd();
            td.setHeaderKey("common.column.contact_description");
            td.setValue(HtmlUtils.formatMultiLineDisplay(contact.getDescription()));
        }
        return template;
    }

    public static boolean validCurrencySymbol(Object input) {
        return input == null || !input.toString().contains(",");
    }

    public static boolean disableAccessEdit(AccessUser user) {
        if (user.getId() == 1) {
            return true;
        }
        return user.getGroupId() != 0;
    }

    public static List<String> getSortableUserColumns() {
        return Arrays.asList(USER_USERNAME, "user_first_name", "user_last_name", USER_DISPLAY_NAME, "user_email");
    }

    public static boolean isSortableUserColumn(String columnName) {
        return AdminUtils.getSortableUserColumns().contains(columnName);
    }

    public static List<String> getUserColumnHeaders() {
        return Arrays.asList("rownum", USER_USERNAME, "user_first_name", "user_last_name", USER_DISPLAY_NAME, "user_email", "user_status");
    }

    public static List<LabelValueBean> getUserAccessOptionList() {
        return Arrays.asList(new LabelValueBean(AdminUtils.getUserAccessIcon(true), "1"), new LabelValueBean(AdminUtils.getUserAccessIcon(false), "0"));
    }

    public static String getUserAccessIcon(boolean hasPermission) {
        if (hasPermission) {
            return Image.getInstance().getPermissionYesIcon();
        }
        return Image.getInstance().getPermissionNoIcon();
    }

    public static List<LabelValueBean> getAttributeStatusList(RequestContext requestContext) {
        return AdminUtils.getAttributeStatusList(requestContext, false);
    }

    public static List<LabelValueBean> getAttributeStatusList(RequestContext requestContext, boolean isDefaultAttr) {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        list.add(new LabelValueBean(Localizer.getText(requestContext, "common.boolean.enabled_disabled.enabled"), "0"));
        if (!isDefaultAttr) {
            list.add(new LabelValueBean(Localizer.getText(requestContext, "common.boolean.enabled_disabled.disabled"), "1"));
        }
        return list;
    }

    public static String[] getBackupCommand() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        String backupFileLocation = ConfigManager.file.getDbBackupRepositoryPath() + ConfigManager.system.getTrailingSlash() + "BACKUP-" + PropertiesManager.get("db.name") + "-" + formatter.format(Calendar.getInstance().getTime()) + ConfigManager.file.getPostgresBackupExtension();
        return new String[]{ConfigManager.file.getDbPostgresProgramPath(), "-f", backupFileLocation, "-h", PropertiesManager.get("db.serverHost"), "-p", PropertiesManager.get("db.serverPort"), "-U", PropertiesManager.get("db.username"), "-F", "p", PropertiesManager.get("db.name")};
    }

    public static String getBackupCommandDisplay() {
        String backupFileLocation = ConfigManager.file.getDbBackupRepositoryPath() + ConfigManager.system.getTrailingSlash() + "BACKUP-" + PropertiesManager.get("db.name") + "-<timestamp>" + ConfigManager.file.getPostgresBackupExtension();
        StringBuilder command = new StringBuilder();
        command.append("\"").append(ConfigManager.file.getDbPostgresProgramPath()).append("\"");
        command.append(" -f ").append("\"").append(backupFileLocation).append("\"");
        command.append(" -h ").append(PropertiesManager.get("db.serverHost"));
        command.append(" -p ").append(PropertiesManager.get("db.serverPort"));
        command.append(" -U ").append(PropertiesManager.get("db.username"));
        command.append(" -i -F p ");
        command.append(PropertiesManager.get("db.name"));
        return command.toString();
    }

    public static String getTitleText(RequestContext requestContext, String titleText) {
        StringBuilder title = new StringBuilder();
        title.append(ConfigManager.system.getCompanyName().isEmpty() ? Localizer.getText(requestContext, "common.app.shortName") : ConfigManager.system.getCompanyName());
        if (titleText != null) {
            title.append(" - ");
            title.append(titleText);
        }
        return title.toString();
    }

    public static List<LabelValueBean> getGroupOptions(RequestContext requestContext) throws DatabaseException {
        AdminService adminService = ServiceProvider.getAdminService(requestContext);
        List<AccessGroup> groups = adminService.getGroups(new QueryCriteria());
        ArrayList<LabelValueBean> groupIdOptions = new ArrayList<LabelValueBean>();
        groupIdOptions.add(new SelectOneLabelValueBean(requestContext, "0"));
        for (AccessGroup group : groups) {
            groupIdOptions.add(new LabelValueBean(group.getName(), String.valueOf(group.getId())));
        }
        return groupIdOptions;
    }

    public static String getSystemUsername(RequestContext requestContext, AccessUser accessUser) {
        if (accessUser == null || accessUser.getId() == 0) {
            return "";
        }
        String username = ConfigManager.system.getUsernameDisplay().equals(USER_USERNAME) ? accessUser.getUsername() : accessUser.getDisplayName();
        return AdminUtils.getSystemUsername(requestContext, accessUser.getId(), username);
    }

    public static String getSystemUsername(RequestContext requestContext, Integer userId, String username) {
        if (userId == 0) {
            return "";
        }
        if (StringUtils.isEmpty(username)) {
            username = Localizer.getText(requestContext, "admin.userDelete.userRemoved");
        }
        return username;
    }

    public static String getUsernameSort() {
        return ConfigManager.system.getUsernameDisplay().equals(USER_USERNAME) ? USER_USERNAME : USER_DISPLAY_NAME;
    }

    public static Map<Integer, Integer> getObjectTypeMap() {
        return objectTypeMap;
    }

    public static List<LabelValueBean> getUserOptions(RequestContext requestContext) throws Exception {
        return AdminUtils.getUserOptions(requestContext, null);
    }

    public static List<LabelValueBean> getUserOptions(RequestContext requestContext, Integer includedUserId) throws Exception {
        UserSearch userSearch = new UserSearch();
        if (includedUserId != null) {
            userSearch.put("nonDisabledExceptSpecified", includedUserId);
        } else {
            userSearch.put("userStatus", AttributeFieldIds.USER_STATUS_ENABLED);
        }
        QueryCriteria query = new QueryCriteria(userSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(requestContext);
        ArrayList<LabelValueBean> userOptions = new ArrayList<LabelValueBean>();
        for (AccessUser user : adminService.getUsers(query)) {
            userOptions.add(new LabelValueBean(AdminUtils.getSystemUsername(requestContext, user), String.valueOf(user.getId())));
        }
        return userOptions;
    }

    public static String getAttributeGroupKey(RequestContext requestContext, AttributeGroup group) {
        String key = "";
        if (group != null) {
            key = HtmlUtils.encode(group.getName()) + "<a href=\"" + group.getId() + "\"></a>";
        } else if (requestContext != null) {
            key = "<a href=\"0\"></a>" + Localizer.getText(requestContext, "common.template.customFields");
        }
        return key;
    }

    public static String getAttributeGroupKey(AttributeGroup group) {
        return AdminUtils.getAttributeGroupKey(null, group);
    }

    public static List<LabelValueBean> getAttributeGroupOptions(RequestContext requestContext, Integer objectTypeId) throws Exception {
        Map<Integer, AttributeGroup> groupMap = new CacheManager(requestContext).getCustomAttrGroupsCache(objectTypeId);
        ArrayList<LabelValueBean> attrGroupOptions = new ArrayList<LabelValueBean>();
        if (!groupMap.values().isEmpty()) {
            attrGroupOptions.add(new SelectOneLabelValueBean(requestContext, "0"));
            for (AttributeGroup group : groupMap.values()) {
                attrGroupOptions.add(new LabelValueBean(group.getName(), String.valueOf(group.getId())));
            }
        }
        return attrGroupOptions;
    }

    public static String getPermissionLabel(RequestContext requestContext, String permName) {
        StringBuilder accessText = new StringBuilder();
        accessText.append(Localizer.getText(requestContext, "system.permissions." + permName));
        accessText.append(": ");
        String permDesc = Localizer.getText(requestContext, "system.permissions." + permName + ".desc");
        if (permDesc != null) {
            Link link = new Link(requestContext);
            link.setInlineImage(Image.getInstance().getInfo(permDesc));
            accessText.append(link);
        }
        return accessText.toString();
    }

    static {
        objectTypeMap.put(ObjectTypes.HARDWARE, Attributes.HARDWARE_TYPE);
        objectTypeMap.put(ObjectTypes.SOFTWARE, Attributes.SOFTWARE_TYPE);
        objectTypeMap.put(ObjectTypes.ISSUE, Attributes.ISSUE_TYPE);
        objectTypeMap.put(ObjectTypes.CONTRACT, Attributes.CONTRACT_TYPE);
    }
}

