/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public class CalendarUtils {
    public static final String[] DATE_LIST = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static final String[] MONTH_LIST = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    public static final String[] WEEKDAY_LIST = new String[]{"0", "1", "2", "3", "4", "5", "6"};

    public static boolean isValidYear(String reqYear) {
        if (!NumberUtils.isInteger(reqYear)) {
            return false;
        }
        int minYear = ConfigManager.app.getCalendarMinYear();
        GregorianCalendar calendar = new GregorianCalendar();
        int curYear = calendar.get(1);
        int maxYear = curYear + ConfigManager.app.getCalendarMaxYearPlus();
        int year = Integer.parseInt(reqYear);
        return year > minYear && year < maxYear;
    }

    public static int getCurYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(1);
    }

    public static List<LabelValueBean> getDateOptions(RequestContext requestContext) {
        ArrayList<LabelValueBean> dateOptions = new ArrayList<LabelValueBean>();
        dateOptions.add(new LabelValueBean(Localizer.getText(requestContext, "common.calendar.selectDate"), ""));
        for (String date : DATE_LIST) {
            dateOptions.add(new LabelValueBean(date, date));
        }
        return dateOptions;
    }

    public static List<LabelValueBean> getMonthOptions(RequestContext requestContext) {
        ArrayList<LabelValueBean> monthOptions = new ArrayList<LabelValueBean>();
        monthOptions.add(new LabelValueBean(Localizer.getText(requestContext, "common.calendar.selectMonth"), ""));
        for (String month : MONTH_LIST) {
            monthOptions.add(new LabelValueBean(Localizer.getText(requestContext, "common.calendar.month." + month), month));
        }
        return monthOptions;
    }

    public static List<LabelValueBean> getYearOptions(RequestContext requestContext) {
        return CalendarUtils.getExtraYearOptions(requestContext, 0);
    }

    public static List<LabelValueBean> getExtraYearOptions(RequestContext requestContext, int previousYear) {
        int startYear = CalendarUtils.getCurYear() - ConfigManager.app.getNumPastYears();
        int endYear = CalendarUtils.getCurYear() + ConfigManager.app.getNumFutureYears();
        ArrayList<LabelValueBean> yearOptions = new ArrayList<LabelValueBean>();
        yearOptions.add(new LabelValueBean(Localizer.getText(requestContext, "common.calendar.selectYear"), ""));
        if (previousYear != 0 && previousYear < startYear) {
            yearOptions.add(new LabelValueBean(String.valueOf(previousYear), String.valueOf(previousYear)));
        }
        for (int year = startYear; year <= endYear; ++year) {
            yearOptions.add(new LabelValueBean(String.valueOf(year), String.valueOf(year)));
        }
        return yearOptions;
    }

    public static List<LabelValueBean> getPastYearOptions(RequestContext requestContext) {
        return CalendarUtils.getExtraPastYearOptions(requestContext, 0);
    }

    public static List<LabelValueBean> getExtraPastYearOptions(RequestContext requestContext, int previousYear) {
        int startYear = CalendarUtils.getCurYear() - ConfigManager.app.getNumPastYears();
        ArrayList<LabelValueBean> yearOptions = new ArrayList<LabelValueBean>();
        yearOptions.add(new LabelValueBean(Localizer.getText(requestContext, "common.calendar.selectYear"), ""));
        for (int year = CalendarUtils.getCurYear(); year >= startYear; --year) {
            yearOptions.add(new LabelValueBean(String.valueOf(year), String.valueOf(year)));
        }
        if (previousYear != 0 && previousYear < startYear) {
            yearOptions.add(new LabelValueBean(String.valueOf(previousYear), String.valueOf(previousYear)));
        }
        return yearOptions;
    }
}

