/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core;

import com.kwoksys.action.admin.manageusers.UserSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;

public class UserSearch
extends BaseSearch {
    public static final String USERNAME = "username";
    public static final String USERNAME_EQUALS = "usernameEquals";
    public static final String USER_EMAIL = "email";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String USER_STATUS = "userStatus";
    public static final String LOGGED_IN_USERS = "loggedInUsers";
    public static final String NON_DISABLED = "nonDisabledExceptSpecified";

    public void prepareMap(UserSearchForm userSearchForm, RequestContext requestContext) {
        String email = userSearchForm.getEmail();
        String username = userSearchForm.getUsername();
        String firstName = userSearchForm.getFirstName();
        String lastName = userSearchForm.getLastName();
        String displayName = userSearchForm.getDisplayName();
        int status = userSearchForm.getStatus();
        if (!username.isEmpty()) {
            this.searchCriteriaMap.put(USERNAME, username);
        }
        if (!firstName.isEmpty()) {
            this.searchCriteriaMap.put(FIRST_NAME, firstName);
        }
        if (!lastName.isEmpty()) {
            this.searchCriteriaMap.put(LAST_NAME, lastName);
        }
        if (!displayName.isEmpty()) {
            this.searchCriteriaMap.put(DISPLAY_NAME, displayName);
        }
        if (!email.isEmpty()) {
            this.searchCriteriaMap.put(USER_EMAIL, email);
        }
        if (status != 0) {
            this.searchCriteriaMap.put(USER_STATUS, status);
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(NON_DISABLED)) {
            query.appendWhereClause("(status = " + AttributeFieldIds.USER_STATUS_ENABLED + " or user_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(NON_DISABLED)) + ")");
        }
        if (this.searchCriteriaMap.containsKey(USER_STATUS)) {
            query.appendWhereClause("status = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(USER_STATUS)));
        }
        if (this.searchCriteriaMap.containsKey(USERNAME_EQUALS)) {
            query.appendWhereClause("lower(u.username) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(USERNAME_EQUALS)) + "')");
        }
        if (this.searchCriteriaMap.containsKey(USERNAME)) {
            query.appendWhereClause("lower(u.username) like lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(USERNAME)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(FIRST_NAME)) {
            query.appendWhereClause("lower(u.first_name) like lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(FIRST_NAME)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(LAST_NAME)) {
            query.appendWhereClause("lower(u.last_name) like lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(LAST_NAME)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(DISPLAY_NAME)) {
            query.appendWhereClause("lower(u.display_name) like lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(DISPLAY_NAME)) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(USER_EMAIL)) {
            query.appendWhereClause("lower(u.email) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(USER_EMAIL)) + "')");
        }
        if (this.searchCriteriaMap.containsKey("excludedDefaultAdmin")) {
            query.appendWhereClause("u.user_id != 1");
        }
        if (this.searchCriteriaMap.containsKey(LOGGED_IN_USERS)) {
            query.appendWhereClause("u.user_id in (select user_id from access_user where session_key is not null and extract(epoch from (now() - last_visit))<" + ConfigManager.auth.getSessionTimeoutSeconds() + " )");
        }
        if (this.searchCriteriaMap.containsKey("issueSelectedSubscribers")) {
            query.appendWhereClause("user_id in (select user_id from issue_subscription where issue_id= " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("issueSelectedSubscribers")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("issueAvailableSubscribers")) {
            query.appendWhereClause("user_id not in (select user_id from issue_subscription where issue_id= " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("issueAvailableSubscribers")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("inGroupId")) {
            query.appendWhereClause("u.user_id in (select user_id from access_group_user_map where group_id= " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("inGroupId")) + ")");
        }
        if (this.searchCriteriaMap.containsKey("notInGroup")) {
            query.appendWhereClause("u.user_id not in (select user_id from access_group_user_map)");
        }
    }
}

