/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core.dataimport;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.dataimport.ImportManager;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.ImportItem;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HardwareImport
extends ImportManager {
    private static final Logger LOGGER = Logger.getLogger(HardwareImport.class.getName());

    @Override
    protected void importData(List<String[]> data, boolean validateOnly) throws Exception {
        Iterator<String[]> rowIter = data.iterator();
        List<String> columnHeaders = Arrays.asList(rowIter.next());
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        HashMap<String, Integer> userIdMap = new HashMap<String, Integer>();
        Map<String, AttributeField> locationMap = attributeManager.getAttrNameMapCache(Attributes.HARDWARE_LOCATION);
        Map<String, AttributeField> statusMap = attributeManager.getAttrNameMapCache(Attributes.HARDWARE_STATUS);
        Map<String, AttributeField> typeMap = attributeManager.getAttrNameMapCache(Attributes.HARDWARE_TYPE);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Map<Integer, Attribute> typeCustomFields = new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.HARDWARE);
        while (rowIter.hasNext()) {
            boolean overwrite = !this.dataImportForm.isAllowDuplicate();
            ImportItem importItem = new ImportItem();
            importItem.setRowNum(++this.rowNum);
            try {
                int colNumber;
                String[] columns = rowIter.next();
                Hardware hardware = null;
                if (overwrite && (colNumber = columnHeaders.indexOf("hardware_name")) != -1) {
                    String hardwareName = columns[colNumber].trim();
                    hardware = hardwareService.getSingleHardwareByName(hardwareName);
                }
                if (hardware == null) {
                    hardware = new Hardware();
                    overwrite = false;
                }
                HashMap<String, String> importCustomFields = new HashMap<String, String>();
                ActionMessages errors = new ActionMessages();
                for (int i = 0; i < columns.length; ++i) {
                    AttributeField attrValue;
                    Integer companyId;
                    String key = columnHeaders.get(i).trim();
                    String value = columns[i].trim();
                    if (value.isEmpty()) continue;
                    if (key.equals("hardware_name")) {
                        hardware.setName(value);
                        importItem.setTitle(value);
                        continue;
                    }
                    if (key.equals("hardware_description")) {
                        hardware.setDescription(value);
                        continue;
                    }
                    if (key.equals("hardware_model_name")) {
                        hardware.setModelName(value);
                        continue;
                    }
                    if (key.equals("hardware_model_number")) {
                        hardware.setModelNumber(value);
                        continue;
                    }
                    if (key.equals("hardware_serial_number")) {
                        hardware.setSerialNumber(value);
                        continue;
                    }
                    if (key.equals("hardware_purchase_price")) {
                        hardware.setPurchasePrice(value);
                        continue;
                    }
                    if (key.equals("hardware_purchase_date")) {
                        try {
                            hardware.setHardwarePurchaseDate(value);
                        }
                        catch (Exception e) {
                            errors.add("invalidDate", new ActionMessage("import.validate.message.invalidDate", new Object[]{Localizer.getText(this.requestContext, "common.column.hardware_purchase_date"), value}));
                        }
                        continue;
                    }
                    if (key.equals("hardware_warranty_expire_date")) {
                        try {
                            hardware.setHardwareWarrantyExpireDate(value);
                        }
                        catch (Exception e) {
                            errors.add("invalidDate", new ActionMessage("import.validate.message.invalidDate", new Object[]{Localizer.getText(this.requestContext, "common.column.hardware_warranty_expire_date"), value}));
                        }
                        continue;
                    }
                    if (key.equals("hardware_owner_username")) {
                        Integer userId;
                        if (userIdMap.containsKey(value)) {
                            userId = (Integer)userIdMap.get(value);
                        } else {
                            userId = adminService.getUserIdByUsername(value);
                            userIdMap.put(value, userId);
                        }
                        if (userId != null) {
                            if (!userId.equals(hardware.getOwnerId())) {
                                if (hardware.getOwnerId() != null && hardware.getOwnerId() != 0) {
                                    new CacheManager(this.requestContext).removeUserCache(hardware.getOwnerId());
                                }
                                new CacheManager(this.requestContext).removeUserCache(userId);
                            }
                            hardware.setOwnerId(userId);
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_owner_name"), value}));
                        continue;
                    }
                    if (key.equals("hardware_manufacturer_name")) {
                        companyId = this.getCompanyId(value);
                        if (companyId != null) {
                            hardware.setManufacturerId(companyId);
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_manufacturer_name"), value}));
                        continue;
                    }
                    if (key.equals("hardware_vendor_name")) {
                        companyId = this.getCompanyId(value);
                        if (companyId != null) {
                            hardware.setVendorId(companyId);
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_vendor_name"), value}));
                        continue;
                    }
                    if (key.equals("hardware_location")) {
                        attrValue = locationMap.get(value.toLowerCase());
                        if (attrValue != null) {
                            hardware.setLocation(attrValue.getId());
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_location"), value}));
                        continue;
                    }
                    if (key.equals("hardware_status")) {
                        attrValue = statusMap.get(value.toLowerCase());
                        if (attrValue != null) {
                            hardware.setStatus(attrValue.getId());
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_status"), value}));
                        continue;
                    }
                    if (key.equals("hardware_type")) {
                        attrValue = typeMap.get(value.toLowerCase());
                        if (attrValue != null) {
                            hardware.setType(attrValue.getId());
                            continue;
                        }
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.hardware_type"), value}));
                        continue;
                    }
                    importCustomFields.put(key, value);
                }
                AttributeManager.populateCustomFieldValues(importCustomFields, hardware, typeCustomFields);
                if (errors.isEmpty()) {
                    if (validateOnly) {
                        errors.add(hardwareService.validateHardware(hardware, typeCustomFields));
                    } else if (overwrite) {
                        errors.add(hardwareService.updateHardware(hardware, typeCustomFields));
                    } else {
                        errors.add(hardwareService.addHardware(hardware, typeCustomFields));
                    }
                }
                if (!errors.isEmpty()) {
                    Iterator iter = errors.get();
                    while (iter.hasNext()) {
                        ActionMessage error = (ActionMessage)iter.next();
                        importItem.getErrorMessages().add(Localizer.getText(this.requestContext, error.getKey(), error.getValues()));
                    }
                    importItem.setAction("ERROR");
                } else {
                    importItem.setAction(overwrite ? "UPDATE" : "ADD");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem importing hardware", e);
                importItem.getErrorMessages().add(e.getMessage());
                importItem.setAction("ERROR");
            }
            this.addImportItem(importItem);
        }
        this.buildImportResultsMessage();
    }
}

