/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core.dataimport;

import com.kwoksys.action.admin.dataimport.DataImportForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.dataimport.HardwareImport;
import com.kwoksys.biz.admin.core.dataimport.UserImport;
import com.kwoksys.biz.admin.dto.ImportItem;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ImportManager {
    public static final String IMPORT_TYPE_HARDWARE = "hardware_import";
    public static final String IMPORT_TYPE_USER = "user_import";
    public static final List<String> IMPORT_TYPES = Arrays.asList("hardware_import", "user_import");
    private Map<String, Integer> companyIdMap = new HashMap<String, Integer>();
    protected List<ImportItem> importItems = new ArrayList<ImportItem>();
    protected RequestContext requestContext;
    protected DataImportForm dataImportForm;
    private Map<String, Integer> counts = new HashMap<String, Integer>();
    protected int rowNum = 1;

    public static ImportManager newInstance(RequestContext requestContext, DataImportForm dataImportForm) {
        ImportManager importManager = null;
        if (dataImportForm.getImportType().equals(IMPORT_TYPE_HARDWARE)) {
            importManager = new HardwareImport();
        } else if (dataImportForm.getImportType().equals(IMPORT_TYPE_USER)) {
            importManager = new UserImport();
        }
        if (importManager != null) {
            importManager.setRequestContext(requestContext);
            importManager.setDataImportForm(dataImportForm);
            requestContext.getSession().setAttribute("IMPORT_RESULTS", importManager.getImportItems());
        }
        return importManager;
    }

    public Integer getCompanyId(String value) throws DatabaseException {
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Integer companyId = null;
        if (this.companyIdMap.containsKey(value)) {
            companyId = this.companyIdMap.get(value);
        } else {
            Company company = contactService.getSingleCompanyByName(value);
            if (company != null) {
                companyId = company.getId();
            }
            this.companyIdMap.put(value, companyId);
        }
        return companyId;
    }

    protected void addImportItem(ImportItem importItem) {
        Integer count = this.counts.get(importItem.getAction());
        if (count == null) {
            count = 0;
        }
        this.counts.put(importItem.getAction(), count + 1);
        this.importItems.add(importItem);
    }

    protected void buildImportResultsMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.counts.containsKey("ADD")) {
            sb.append(Localizer.getText(this.requestContext, "import.result.message.ADD", new Object[]{this.counts.get("ADD")})).append(" ");
        }
        if (this.counts.containsKey("UPDATE")) {
            sb.append(Localizer.getText(this.requestContext, "import.result.message.UPDATE", new Object[]{this.counts.get("UPDATE")})).append(" ");
        }
        if (this.counts.containsKey("ERROR")) {
            sb.append(Localizer.getText(this.requestContext, "import.result.message.ERROR", new Object[]{this.counts.get("ERROR")}));
        }
        this.requestContext.getSession().setAttribute("IMPORT_RESULTS_MESSAGE", (Object)sb.toString());
    }

    public List<ImportItem> getImportItems() {
        return this.importItems;
    }

    public void validate(List<String[]> data) throws Exception {
        boolean validateOnly = true;
        this.importData(data, validateOnly);
    }

    public void execute(List<String[]> data) throws Exception {
        boolean validateOnly = false;
        this.importData(data, validateOnly);
    }

    protected abstract void importData(List<String[]> var1, boolean var2) throws Exception;

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void setDataImportForm(DataImportForm dataImportForm) {
        this.dataImportForm = dataImportForm;
    }
}

