/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.core.dataimport;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.dataimport.ImportManager;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.ImportItem;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Keywords;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.validations.InputValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserImport
extends ImportManager {
    private static final Logger LOGGER = Logger.getLogger(UserImport.class.getName());
    private Map<String, AccessGroup> groupMap = new HashMap<String, AccessGroup>();

    @Override
    protected void importData(List<String[]> data, boolean validateOnly) throws Exception {
        Iterator<String[]> rowIter = data.iterator();
        List<String> columnHeaders = Arrays.asList(rowIter.next());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Map<Integer, Attribute> typeCustomFields = new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.USER);
        for (AccessGroup group : adminService.getGroups(new QueryCriteria())) {
            this.groupMap.put(group.getName().toLowerCase(), group);
        }
        while (rowIter.hasNext()) {
            boolean overwrite = false;
            ImportItem importItem = new ImportItem();
            importItem.setRowNum(++this.rowNum);
            try {
                String username;
                Integer userId;
                String[] columns = rowIter.next();
                AccessUser accessUser = null;
                AccessGroup accessGroup = null;
                int colNumber = columnHeaders.indexOf("username");
                if (colNumber != -1 && (userId = adminService.getUserIdByUsername(username = columns[colNumber].trim())) != null) {
                    accessUser = adminService.getUser(userId);
                }
                if (accessUser == null) {
                    accessUser = new AccessUser();
                } else {
                    overwrite = true;
                }
                HashMap<String, String> importCustomFields = new HashMap<String, String>();
                ActionMessages errors = new ActionMessages();
                InputValidator inputValidator = new InputValidator(this.requestContext, errors);
                Contact contact = contactService.getOptionalContact(accessUser.getContactId());
                for (int i = 0; i < columns.length; ++i) {
                    String key = columnHeaders.get(i).trim();
                    String value = columns[i].trim();
                    if (value.isEmpty()) continue;
                    if (key.equals("username")) {
                        accessUser.setUsername(value);
                        importItem.setTitle(value);
                        continue;
                    }
                    if (key.equals("first_name")) {
                        accessUser.setFirstName(value);
                        continue;
                    }
                    if (key.equals("last_name")) {
                        accessUser.setLastName(value);
                        continue;
                    }
                    if (key.equals("display_name")) {
                        accessUser.setDisplayName(value);
                        continue;
                    }
                    if (key.equals("email")) {
                        accessUser.setEmail(value);
                        continue;
                    }
                    if (key.equals("password")) {
                        accessUser.setPasswordNew(value);
                        accessUser.setPasswordConfirm(value);
                        continue;
                    }
                    if (key.equals("status")) {
                        if (value.equals("ENABLED")) {
                            accessUser.setStatus(AttributeFieldIds.USER_STATUS_ENABLED);
                            continue;
                        }
                        if (value.equals("DISABLED")) {
                            accessUser.setStatus(AttributeFieldIds.USER_STATUS_DISABLED);
                            continue;
                        }
                        errors.add("status", new ActionMessage("import.validate.message.invalidUserStatus", new String[]{StringUtils.join(Keywords.USER_STATUS_LIST, ", ")}));
                        continue;
                    }
                    if (key.equals("group_name")) {
                        accessGroup = this.groupMap.get(value.toLowerCase());
                        if (accessGroup != null) continue;
                        importItem.getWarningMessages().add(Localizer.getText(this.requestContext, "import.validate.message.noMatches", (Object[])new String[]{Localizer.getText(this.requestContext, "common.column.group_name"), value}));
                        continue;
                    }
                    if (key.equals("title")) {
                        contact.setTitle(value);
                        continue;
                    }
                    if (key.equals("work_phone")) {
                        contact.setPhoneWork(value);
                        continue;
                    }
                    if (key.equals("home_phone")) {
                        contact.setPhoneHome(value);
                        continue;
                    }
                    if (key.equals("cell_phone")) {
                        contact.setPhoneMobile(value);
                        continue;
                    }
                    if (key.equals("fax")) {
                        contact.setFax(value);
                        continue;
                    }
                    if (key.equals("street")) {
                        contact.setAddressStreetPrimary(value);
                        continue;
                    }
                    if (key.equals("city")) {
                        contact.setAddressCityPrimary(value);
                        continue;
                    }
                    if (key.equals("state")) {
                        contact.setAddressStatePrimary(value);
                        continue;
                    }
                    if (key.equals("zip_code")) {
                        contact.setAddressZipcodePrimary(value);
                        continue;
                    }
                    if (key.equals("country")) {
                        contact.setAddressCountryPrimary(value);
                        continue;
                    }
                    if (key.equals("homepage_url")) {
                        contact.setHomepageUrl(value);
                        continue;
                    }
                    if (key.equals("notes")) {
                        contact.setDescription(value);
                        continue;
                    }
                    importCustomFields.put(key, value);
                }
                contact.setUserId(accessUser.getId());
                contact.setEmailPrimary(accessUser.getEmail());
                contact.setFirstName(accessUser.getFirstName());
                contact.setLastName(accessUser.getLastName());
                AttributeManager.populateCustomFieldValues(importCustomFields, accessUser, typeCustomFields);
                if (errors.isEmpty()) {
                    if (validateOnly) {
                        errors.add(adminService.validateUser(accessUser, null, typeCustomFields));
                        if (!overwrite || !StringUtils.isEmpty(accessUser.getPasswordNew())) {
                            inputValidator.validatePassword("common.column.user_password", accessUser);
                        }
                    } else if (overwrite) {
                        errors.add(adminService.updateUser(accessUser, accessGroup, contact, typeCustomFields));
                        if (!StringUtils.isEmpty(accessUser.getPasswordNew())) {
                            errors.add(adminService.resetUserPassword(accessUser));
                        }
                        new CacheManager(this.requestContext).removeUserCache(accessUser.getId());
                    } else {
                        errors.add(adminService.addUser(accessUser, accessGroup, contact, typeCustomFields));
                    }
                }
                if (!errors.isEmpty()) {
                    Iterator iter = errors.get();
                    while (iter.hasNext()) {
                        ActionMessage error = (ActionMessage)iter.next();
                        importItem.getErrorMessages().add(Localizer.getText(this.requestContext, error.getKey(), error.getValues()));
                    }
                    importItem.setAction("ERROR");
                } else {
                    importItem.setAction(overwrite ? "UPDATE" : "ADD");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem importing user", e);
                importItem.getErrorMessages().add(e.getMessage());
                importItem.setAction("ERROR");
            }
            this.addImportItem(importItem);
        }
        this.buildImportResultsMessage();
    }
}

