/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.dao;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.GroupPermissionMap;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class AccessGroupDao
extends BaseDao {
    public AccessGroupDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<AccessGroup> getGroups(QueryCriteria query) throws DatabaseException {
        final ArrayList<AccessGroup> groups = new ArrayList<AccessGroup>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectGroupListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AccessGroup group = new AccessGroup();
                group.setId(rs.getInt("group_id"));
                group.setName(StringUtils.replaceNull(rs.getString("group_name")));
                group.setDescription(StringUtils.replaceNull(rs.getString("group_description")));
                groups.add(group);
            }
        };
        this.executeQuery(queryHelper);
        return groups;
    }

    public AccessGroup getGroup(Integer groupId) throws DatabaseException, ObjectNotFoundException {
        final AccessGroup group = new AccessGroup();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectGroupDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                group.setId(rs.getInt("group_id"));
                group.setName(rs.getString("group_name"));
                group.setDescription(rs.getString("group_description"));
                group.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                group.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                group.setCreator(new AccessUser());
                group.getCreator().setId(rs.getInt("creator"));
                group.getCreator().setUsername(rs.getString("creator_username"));
                group.getCreator().setDisplayName(rs.getString("creator_display_name"));
                group.setModifier(new AccessUser());
                group.getModifier().setId(rs.getInt("modifier"));
                group.getModifier().setUsername(rs.getString("modifier_username"));
                group.getModifier().setDisplayName(rs.getString("modifier_display_name"));
            }
        };
        queryHelper.addInputInt(groupId);
        this.executeSingleRecordQuery(queryHelper);
        if (group.getId() != null) {
            return group;
        }
        throw new ObjectNotFoundException("Group ID: " + groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addGroup(AccessGroup group) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.addGroupQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(group.getName());
        queryHelper.addInputStringConvertNull(group.getDescription());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            group.setId((Integer)queryHelper.getSqlOutputs().get(0));
            this.updateGroupMembers(conn, group);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages editGroup(AccessGroup group) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateGroupQuery());
        queryHelper.addInputInt(group.getId());
        queryHelper.addInputStringConvertNull(group.getName());
        queryHelper.addInputStringConvertNull(group.getDescription());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            queryHelper.executeProcedure(conn);
            this.updateGroupMembers(conn, group);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages deleteGroup(AccessGroup group) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.deleteGroupQuery());
        queryHelper.addInputInt(group.getId());
        return this.executeProcedure(queryHelper);
    }

    public List<GroupPermissionMap> getGroupAccess(QueryCriteria query, final Integer groupId) throws DatabaseException {
        final ArrayList<GroupPermissionMap> access = new ArrayList<GroupPermissionMap>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectGroupAccessQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                GroupPermissionMap groupperm = new GroupPermissionMap();
                groupperm.setGroupId(groupId);
                groupperm.setPermId(rs.getInt("perm_id"));
                groupperm.setPermName(rs.getString("perm_name"));
                groupperm.setHasPermission(rs.getInt("has_permission") != 0);
                access.add(groupperm);
            }
        };
        queryHelper.addInputInt(groupId);
        this.executeQuery(queryHelper);
        return access;
    }

    public ActionMessages updateGroupAccess(GroupPermissionMap groupperm) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateGroupAccessQuery());
        queryHelper.addInputInt(groupperm.getGroupId());
        queryHelper.addInputInt(groupperm.getPermId());
        queryHelper.addInputInt(groupperm.getCmd());
        return this.executeProcedure(queryHelper);
    }

    public List<AccessUser> getAvailableMembers(Integer groupId) throws DatabaseException {
        UserSearch userSearch = new UserSearch();
        userSearch.put("excludedDefaultAdmin", "");
        userSearch.put("notInGroup", groupId);
        QueryCriteria query = new QueryCriteria(userSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getUsers(query);
    }

    public List<AccessUser> getGroupMembers(Integer groupId) throws DatabaseException {
        UserSearch userSearch = new UserSearch();
        userSearch.put("excludedDefaultAdmin", "");
        userSearch.put("inGroupId", groupId);
        QueryCriteria query = new QueryCriteria(userSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getUsers(query);
    }

    public void updateGroupMembers(Connection conn, AccessGroup group) throws DatabaseException {
        ArrayList selectedMemberList = group.getSelectedMembers() == null ? new ArrayList() : new ArrayList<Integer>(group.getSelectedMembers());
        CacheManager cacheManager = new CacheManager(this.requestContext);
        for (AccessUser user : this.getGroupMembers(group.getId())) {
            if (selectedMemberList.contains(user.getId())) {
                selectedMemberList.remove(user.getId());
                continue;
            }
            cacheManager.removeUserCache(user.getId());
            this.removeGroupMember(conn, group, user.getId());
        }
        for (Integer userId : selectedMemberList) {
            cacheManager.removeUserCache(userId);
            this.addGroupMember(conn, group, userId);
        }
    }

    public void addGroupMember(Connection conn, AccessGroup group, Integer userId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.addGroupMembersQuery());
        queryHelper.addInputInt(group.getId());
        queryHelper.addInputInt(userId);
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        queryHelper.executeProcedure(conn);
    }

    public void removeGroupMember(Connection conn, AccessGroup group, Integer userId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.removeGroupMembersQuery());
        queryHelper.addInputInt(group.getId());
        queryHelper.addInputInt(userId);
        queryHelper.executeProcedure(conn);
    }
}

