/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.dao;

import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.admin.dto.AttributeValue;
import com.kwoksys.biz.admin.dto.Icon;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AttributeDao
extends BaseDao {
    public AttributeDao(RequestContext requestContext) {
        super(requestContext);
    }

    public Map<Integer, AttributeGroup> getAttributeGroups(Integer objectTypeId) throws DatabaseException {
        final LinkedHashMap<Integer, AttributeGroup> groups = new LinkedHashMap<Integer, AttributeGroup>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeGroupsQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeGroup attributeGroup = new AttributeGroup();
                attributeGroup.setId(rs.getInt("attribute_group_id"));
                attributeGroup.setName(rs.getString("attribute_group_name"));
                groups.put(attributeGroup.getId(), attributeGroup);
            }
        };
        queryHelper.addInputInt(objectTypeId);
        this.executeQuery(queryHelper);
        return groups;
    }

    public AttributeGroup getAttributeGroup(final Integer attributeGroupId, final Integer objectTypeId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList attributeGroups = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeGroupQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeGroup attributeGroup = new AttributeGroup();
                attributeGroup.setId(attributeGroupId);
                attributeGroup.setName(rs.getString("attribute_group_name"));
                attributeGroup.setObjectTypeId(objectTypeId);
                attributeGroups.add(attributeGroup);
            }
        };
        queryHelper.addInputInt(attributeGroupId);
        queryHelper.addInputInt(objectTypeId);
        this.executeSingleRecordQuery(queryHelper);
        if (!attributeGroups.isEmpty()) {
            return (AttributeGroup)attributeGroups.get(0);
        }
        throw new ObjectNotFoundException("Attribute Group ID: " + attributeGroupId);
    }

    public Map<Integer, Attribute> getAttributeList(QueryCriteria query) throws DatabaseException {
        final LinkedHashMap<Integer, Attribute> attributes = new LinkedHashMap<Integer, Attribute>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Attribute attribute = new Attribute();
                attribute.setId(rs.getInt("attribute_id"));
                attribute.setName(StringUtils.replaceNull(rs.getString("attribute_name")));
                attribute.setUrl(StringUtils.replaceNull(rs.getString("attribute_url")));
                attribute.setType(rs.getInt("attribute_type"));
                attribute.setAttributeOptions(StringUtils.replaceNull(rs.getString("attribute_option")));
                attribute.setConvertUrl(rs.getBoolean("attribute_convert_url"));
                attribute.setObjectTypeId(rs.getInt("object_type_id"));
                attribute.setDefaultAttrFieldId(rs.getInt("default_attribute_field_id"));
                attribute.setAttributeGroupId(rs.getInt("attribute_group_id"));
                attribute.setRequired(rs.getInt("is_required") == 1);
                attribute.setInputMask(StringUtils.replaceNull(rs.getString("input_mask")));
                attribute.setDescription(StringUtils.replaceNull(rs.getString("description")));
                attribute.setTypeCurrencySymbol(StringUtils.replaceNull(rs.getString("type_currency_symbol")));
                attributes.put(attribute.getId(), attribute);
            }
        };
        this.executeQuery(queryHelper);
        return attributes;
    }

    public boolean hasCustomFields(QueryCriteria query) throws DatabaseException {
        final MutableBoolean hasCustomFields = new MutableBoolean(false);
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                hasCustomFields.setTrue();
            }
        };
        this.executeSingleRecordQuery(queryHelper);
        return hasCustomFields.isTrue();
    }

    public Attribute getAttribute(Integer attributeId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList attributes = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Attribute attribute = new Attribute();
                attribute.setId(rs.getInt("attribute_id"));
                attribute.setName(rs.getString("attribute_name"));
                attribute.setCustomAttr(rs.getBoolean("is_custom_attr"));
                attribute.setUrl(StringUtils.replaceNull(rs.getString("attribute_url")));
                attribute.setType(rs.getInt("attribute_type"));
                attribute.setAttributeOptions(StringUtils.replaceNull(rs.getString("attribute_option")));
                attribute.setConvertUrl(rs.getBoolean("attribute_convert_url"));
                attribute.setObjectTypeId(rs.getInt("object_type_id"));
                attribute.setObjectKey(rs.getString("object_key"));
                attribute.setAttributeGroupId(rs.getInt("attribute_group_id"));
                attribute.setAttrFieldsEditable(rs.getBoolean("is_editable"));
                attribute.setInputMask(StringUtils.replaceNull(rs.getString("input_mask")));
                attribute.setDescription(StringUtils.replaceNull(rs.getString("description")));
                attribute.setTypeCurrencySymbol(StringUtils.replaceNull(rs.getString("type_currency_symbol")));
                int defaultAttrFieldId = rs.getInt("default_attribute_field_id");
                attribute.setDefaultAttrFieldId(defaultAttrFieldId);
                attribute.setDefaultAttrFieldEditable(defaultAttrFieldId != 0);
                int isRequired = rs.getInt("is_required");
                attribute.setRequired(isRequired == 1);
                attribute.setRequiredFieldEditable(isRequired != -1);
                attributes.add(attribute);
            }
        };
        queryHelper.addInputInt(attributeId);
        this.executeSingleRecordQuery(queryHelper);
        if (!attributes.isEmpty()) {
            return (Attribute)attributes.get(0);
        }
        throw new ObjectNotFoundException("Attribute ID: " + attributeId);
    }

    public Map<Integer, AttributeField> getAttributeFields(QueryCriteria query) throws DatabaseException {
        final LinkedHashMap<Integer, AttributeField> attrFields = new LinkedHashMap<Integer, AttributeField>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeFieldListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeField attrField = new AttributeField();
                attrField.setAttributeId(rs.getInt("attribute_id"));
                attrField.setId(rs.getInt("attribute_field_id"));
                attrField.setName(rs.getString("attribute_field_name"));
                attrField.setDescription(StringUtils.replaceNull(rs.getString("attribute_field_description")));
                attrField.setIconId(rs.getInt("icon_id"));
                attrField.setSystemIcon(rs.getBoolean("is_system_icon"));
                attrField.setIconPath(StringUtils.replaceNull(rs.getString("icon_path")));
                attrField.setDisabled(rs.getBoolean("is_disabled"));
                attrFields.put(attrField.getId(), attrField);
            }
        };
        this.executeQuery(queryHelper);
        return attrFields;
    }

    public AttributeField getAttributeField(QueryCriteria query, Integer attrFieldId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList attrFields = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeFieldQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AttributeField attrField = new AttributeField();
                attrField.setAttributeId(rs.getInt("attribute_id"));
                attrField.setId(rs.getInt("attribute_field_id"));
                attrField.setName(rs.getString("attribute_field_name"));
                attrField.setDescription(StringUtils.replaceNull(rs.getString("attribute_field_description")));
                attrField.setIconId(rs.getInt("icon_id"));
                attrField.setSystemIcon(rs.getBoolean("is_system_icon"));
                attrField.setIconPath(StringUtils.replaceNull(rs.getString("icon_path")));
                attrField.setDisabled(rs.getBoolean("is_disabled"));
                attrFields.add(attrField);
            }
        };
        queryHelper.addInputInt(attrFieldId);
        this.executeSingleRecordQuery(queryHelper);
        if (!attrFields.isEmpty()) {
            return (AttributeField)attrFields.get(0);
        }
        throw new ObjectNotFoundException("Attribute Field ID: " + attrFieldId);
    }

    public Map<Integer, Object> getCustomAttributeValueMap(QueryCriteria query) throws DatabaseException {
        final HashMap<Integer, Object> values = new HashMap<Integer, Object>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeValuesQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Integer attrId = rs.getInt("attribute_id");
                String attrValue = StringUtils.replaceNull(rs.getString("attr_value"));
                Integer attributeType = rs.getInt("attribute_type");
                if (attributeType.equals(Attribute.ATTR_TYPE_MULTISELECT)) {
                    ArrayList<String> list = (ArrayList<String>)values.get(attrId);
                    if (list == null) {
                        list = new ArrayList<String>();
                        values.put(attrId, list);
                    }
                    list.add(attrValue);
                } else {
                    values.put(attrId, attrValue);
                }
            }
        };
        this.executeQuery(queryHelper);
        return values;
    }

    public List<Integer> getSavedAttributeFieldTypes(QueryCriteria query, Integer attrFieldId) throws DatabaseException {
        final ArrayList<Integer> values = new ArrayList<Integer>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeFieldTypesQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                values.add(rs.getInt("linked_attribute_id"));
            }
        };
        queryHelper.addInputInt(attrFieldId);
        this.executeQuery(queryHelper);
        return values;
    }

    public Set<Integer> getAttributeFieldTypesByField(QueryCriteria query, Integer linkedAttrId) throws DatabaseException {
        final HashSet<Integer> values = new HashSet<Integer>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeFieldTypesByLinkedAttrQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                values.add(rs.getInt("attribute_field_id"));
            }
        };
        queryHelper.addInputInt(linkedAttrId);
        this.executeQuery(queryHelper);
        return values;
    }

    public List<Icon> getIcons(Integer attributeId) throws DatabaseException {
        final ArrayList<Icon> icons = new ArrayList<Icon>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeIconsQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Icon icon = new Icon();
                icon.setId(rs.getInt("icon_id"));
                icon.setSystemIcon(rs.getInt("is_system_icon") == 1);
                if (icon.isSystemIcon()) {
                    icon.setAppPath(StringUtils.replaceNull(rs.getString("icon_path")));
                } else {
                    icon.setPath(StringUtils.replaceNull(rs.getString("icon_path")));
                }
                icon.setAttributeId(rs.getInt("attribute_id"));
                icons.add(icon);
            }
        };
        queryHelper.addInputInt(attributeId);
        this.executeQuery(queryHelper);
        return icons;
    }

    public ActionMessages addAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.addAttributeGroupQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(attributeGroup.getObjectTypeId());
        queryHelper.addInputString(attributeGroup.getName());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            attributeGroup.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages updateAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateAttributeGroupQuery());
        queryHelper.addInputInt(attributeGroup.getId());
        queryHelper.addInputInt(attributeGroup.getObjectTypeId());
        queryHelper.addInputString(attributeGroup.getName());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deleteAttributeGroup(AttributeGroup attributeGroup) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.deleteAttributeGroupQuery());
        queryHelper.addInputInt(attributeGroup.getId());
        queryHelper.addInputInt(attributeGroup.getObjectTypeId());
        return this.executeProcedure(queryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addCustomAttribute(Attribute attr) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.getAttributeAddQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(attr.getObjectTypeId());
        queryHelper.addInputString(attr.getName());
        queryHelper.addInputStringConvertNull(attr.getDescription());
        queryHelper.addInputInt(attr.getType());
        queryHelper.addInputStringConvertNull(attr.getAttributeOption());
        queryHelper.addInputInt(attr.isConvertUrl() ? 1 : 0);
        queryHelper.addInputStringConvertNull(attr.getUrl());
        queryHelper.addInputIntegerConvertNull(null);
        queryHelper.addInputIntegerConvertNull(attr.getAttributeGroupId());
        queryHelper.addInputStringConvertNull(attr.getInputMask());
        queryHelper.addInputStringConvertNull(attr.getTypeCurrencySymbol());
        queryHelper.addInputInt(attr.isRequired() ? 1 : 0);
        try {
            queryHelper.executeProcedure(conn);
            attr.setId((Integer)queryHelper.getSqlOutputs().get(0));
            this.updateAttributeFieldMap(conn, attr);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages updateCustomAttribute(Attribute attr) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.getAttributeUpdateQuery());
        queryHelper.addInputInt(attr.getId());
        queryHelper.addInputString(attr.getName());
        queryHelper.addInputStringConvertNull(attr.getDescription());
        queryHelper.addInputInt(attr.getType());
        queryHelper.addInputStringConvertNull(attr.getAttributeOption());
        queryHelper.addInputInt(attr.isConvertUrl() ? 1 : 0);
        queryHelper.addInputStringConvertNull(attr.getUrl());
        queryHelper.addInputIntegerConvertNull(attr.getAttributeGroupId());
        queryHelper.addInputStringConvertNull(attr.getInputMask());
        queryHelper.addInputStringConvertNull(attr.getTypeCurrencySymbol());
        queryHelper.addInputInt(attr.isRequired() ? 1 : 0);
        try {
            queryHelper.executeProcedure(conn);
            this.updateAttributeFieldMap(conn, attr);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages updateSystemAttribute(Attribute attr) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateSystemAttributeQuery());
        queryHelper.addInputInt(attr.getId());
        queryHelper.addInputInt(attr.isRequired() ? 1 : 0);
        queryHelper.addInputIntegerConvertNull(attr.getDefaultAttrFieldId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deleteAttribute(Attribute attr) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.deleteAttributeQuery());
        queryHelper.addInputInt(attr.getId());
        return this.executeProcedure(queryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages addAttributeField(AttributeField attrField) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.insertAttributeFieldQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(attrField.getAttributeId());
        queryHelper.addInputStringConvertNull(attrField.getName());
        queryHelper.addInputStringConvertNull(attrField.getDescription());
        if (attrField.isDisabled()) {
            queryHelper.addInputInt(1);
        } else {
            queryHelper.addInputIntegerConvertNull(null);
        }
        queryHelper.addInputIntegerConvertNull(attrField.getIconId());
        try {
            queryHelper.executeProcedure(conn);
            attrField.setId((Integer)queryHelper.getSqlOutputs().get(0));
            this.updateAttributeFieldMap(conn, attrField);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages updateAttributeField(AttributeField attrField) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateAttributeFieldQuery());
        queryHelper.addInputInt(attrField.getAttributeId());
        queryHelper.addInputInt(attrField.getId());
        queryHelper.addInputStringConvertNull(attrField.getName());
        queryHelper.addInputStringConvertNull(attrField.getDescription());
        if (attrField.isDisabled()) {
            queryHelper.addInputInt(1);
        } else {
            queryHelper.addInputIntegerConvertNull(null);
        }
        queryHelper.addInputIntegerConvertNull(attrField.getIconId());
        try {
            queryHelper.executeProcedure(conn);
            this.updateAttributeFieldMap(conn, attrField);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public void updateAttributeValue(Connection conn, Integer objectId, Map<Integer, AttributeValue> customValues) throws DatabaseException {
        String sqlQuery = AdminQueries.updateAttributeValueQuery();
        for (AttributeValue value : customValues.values()) {
            QueryHelper queryHelper = new QueryHelper(sqlQuery);
            queryHelper.addInputInt(objectId);
            queryHelper.addInputInt(value.getAttributeId());
            queryHelper.addInputStringConvertNull(value.getRawValue());
            queryHelper.executeProcedure(conn);
        }
    }

    public void updateAttributeFieldMap(Connection conn, AttributeField attrField) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.deleteAttributeFieldMapQuery());
        queryHelper.addInputInt(attrField.getAttributeId());
        queryHelper.addInputInt(attrField.getId());
        queryHelper.addInputIntegerConvertNull(0);
        queryHelper.executeProcedure(conn);
        if (attrField.getLinkedAttrIds() != null) {
            for (Integer linkedAttrId : attrField.getLinkedAttrIds()) {
                this.updateAttributeFieldMap(conn, attrField.getAttributeId(), attrField.getId(), linkedAttrId);
            }
        }
    }

    public void updateAttributeFieldMap(Connection conn, Attribute attr) throws DatabaseException {
        if (attr.getAttrFieldIds() == null) {
            return;
        }
        Integer objectAttrType = AdminUtils.getObjectTypeMap().get(attr.getObjectTypeId());
        if (objectAttrType == null) {
            return;
        }
        QueryHelper queryHelper = new QueryHelper(AdminQueries.deleteAttributeFieldMapQuery());
        queryHelper.addInputInt(objectAttrType);
        queryHelper.addInputIntegerConvertNull(0);
        queryHelper.addInputInt(attr.getId());
        queryHelper.executeProcedure(conn);
        for (Integer attrFieldId : attr.getAttrFieldIds()) {
            this.updateAttributeFieldMap(conn, AdminUtils.getObjectTypeMap().get(attr.getObjectTypeId()), attrFieldId, attr.getId());
        }
    }

    private void updateAttributeFieldMap(Connection conn, Integer attrId, Integer attrFieldId, Integer linkedAttrId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AdminQueries.updateAttributeFieldMapQuery());
        queryHelper.addInputInt(attrId);
        queryHelper.addInputInt(attrFieldId);
        queryHelper.addInputInt(linkedAttrId);
        queryHelper.executeProcedure(conn);
    }
}

