/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.admin.dto;

import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.Date;

public class AccessUser
extends BaseObject {
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "user_first_name";
    public static final String LAST_NAME = "user_last_name";
    public static final String DISPLAY_NAME = "user_display_name";
    public static final String EMAIL = "user_email";
    public static final String STATUS = "user_status";
    public static final String LAST_LOGON = "user_last_logon";
    public static final String LAST_VISIT = "user_last_visit";
    public static final String IS_DEFAULT_USER = "is_default_user";
    private Integer id;
    private String displayName;
    private String username;
    private String firstName;
    private String lastName;
    private String email;
    private int status = AttributeFieldIds.USER_STATUS_DISABLED;
    private String requestedPassword;
    private String passwordNew;
    private String passwordConfirm;
    private String hashedPassword;
    private Date lastLogonTime;
    private Date lastVisitTime;
    private int hardwareCount = 0;
    private Integer contactId = 0;
    private Integer groupId = 0;
    private String groupName;
    private String sessionToken;
    private boolean isDefaultUser;
    private int invalidLogonCount = 0;
    private Date invalidLogonDate;
    private boolean removed;

    public AccessUser() {
        super(ObjectTypes.USER);
    }

    public AccessUser(Integer id) {
        this();
        this.id = id;
    }

    public boolean isGuessUser() {
        return this.id.equals(Access.GUEST_USER_ID);
    }

    public boolean isLoggedOn() {
        return !this.id.equals(Access.GUEST_USER_ID);
    }

    public boolean isLoggedOn(RequestContext requestContext) {
        return !this.sessionToken.isEmpty() && !this.isGuessUser() && (requestContext.getSysdate().getTime() - this.lastVisitTime.getTime()) / 1000L < (long)ConfigManager.auth.getSessionTimeoutSeconds();
    }

    public boolean isAccountDisabled() {
        return this.status == AttributeFieldIds.USER_STATUS_DISABLED;
    }

    public boolean isAccountEnabled() {
        return this.status == AttributeFieldIds.USER_STATUS_ENABLED;
    }

    public boolean hasPermission(Integer permissionId) throws DatabaseException {
        return Access.hasPermission(this, permissionId);
    }

    public boolean hasPermission(String pageName) throws Exception {
        return Access.hasPermission(this, pageName);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRequestedPassword() {
        return this.requestedPassword;
    }

    public void setRequestedPassword(String requestedPassword) {
        this.requestedPassword = requestedPassword;
    }

    public String getPasswordNew() {
        return this.passwordNew;
    }

    public void setPasswordNew(String passwordNew) {
        this.passwordNew = passwordNew;
    }

    public String getPasswordConfirm() {
        return this.passwordConfirm;
    }

    public void setPasswordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
    }

    public String getLastLogonTime() {
        return DatetimeUtils.toLocalDatetime(this.lastLogonTime);
    }

    public void setLastLogonTime(Date lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    public String getFormattedLastVisitTime() {
        return DatetimeUtils.toLocalDatetime(this.lastVisitTime);
    }

    public void setLastVisitTime(Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public Integer getContactId() {
        return this.contactId;
    }

    public void setContactId(Integer contactId) {
        this.contactId = contactId;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getHardwareCount() {
        return this.hardwareCount;
    }

    public void setHardwareCount(int hardwareCount) {
        this.hardwareCount = hardwareCount;
    }

    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    public boolean isDefaultUser() {
        return this.isDefaultUser;
    }

    public void setDefaultUser(boolean defaultUser) {
        this.isDefaultUser = defaultUser;
    }

    public int getInvalidLogonCount() {
        return this.invalidLogonCount;
    }

    public void setInvalidLogonCount(int invalidLogonCount) {
        this.invalidLogonCount = invalidLogonCount;
    }

    public Date getInvalidLogonDate() {
        return this.invalidLogonDate;
    }

    public void setInvalidLogonDate(Date invalidLogonDate) {
        this.invalidLogonDate = invalidLogonDate;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }
}

