/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.auth;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.AuthManager;
import com.kwoksys.biz.auth.core.AuthUtils;
import com.kwoksys.biz.auth.dao.AuthDao;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.ldap.Ldap;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.UsernameNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.session.CookieManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthService {
    private RequestContext requestContext;

    public AuthService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Set<Integer> getAccessGroupPerms(Integer groupId) throws DatabaseException {
        return new AuthDao(this.requestContext).getAccessGroupPerms(groupId);
    }

    public Set<Integer> getAccessUserPerms(Integer userId) throws DatabaseException {
        return new AuthDao(this.requestContext).getAccessUserPerms(userId);
    }

    public Map<Integer, Set<Integer>> getAccessPermPages() throws DatabaseException {
        return new AuthDao(this.requestContext).getAccessPermPages();
    }

    public Map getAccessPages() throws DatabaseException {
        return new AuthDao(this.requestContext).getAccessPages();
    }

    public ActionMessages updateUserLogoutSession(Integer userId) throws DatabaseException {
        return new AuthDao(this.requestContext).updateUserLogoutSession(userId);
    }

    public boolean isValidUserSession(Integer userId, String sessionTokenCookie) throws DatabaseException {
        if (sessionTokenCookie.isEmpty()) {
            return false;
        }
        return new AuthDao(this.requestContext).isValidUserSession(userId, sessionTokenCookie);
    }

    public ActionMessages authenticateUser(AccessUser accessUser) throws DatabaseException {
        AuthManager authManager = new AuthManager(this.requestContext, accessUser);
        ActionMessages errors = authManager.validateCredentialFormat();
        if (!errors.isEmpty()) {
            return errors;
        }
        errors = authManager.validateUserName();
        if (!errors.isEmpty()) {
            return errors;
        }
        errors = authManager.validateUserStatus();
        if (!errors.isEmpty()) {
            return errors;
        }
        if (authManager.isConcurrentUsersLimitExceeded(accessUser)) {
            errors.add("login", new ActionMessage("auth.login.error.concurrentLimitExceeded", new String[]{"http://www.kwoksys.com/pages/compare-editions.php"}).setEncodeHtml(false));
            return errors;
        }
        boolean isValidLogin = false;
        if (ConfigManager.auth.isDbAuthEnabled()) {
            try {
                isValidLogin = authManager.authenticateDbUser();
            }
            catch (Exception e) {
                errors.add("login", new ActionMessage("common.error.application"));
                return errors;
            }
        }
        if (!isValidLogin && ConfigManager.auth.isLdapAuthEnabled()) {
            isValidLogin = authManager.authenticateLdapUser();
        }
        AuthDao authDao = new AuthDao(this.requestContext);
        if (isValidLogin) {
            authDao.updateUserLogonSession(accessUser, AuthUtils.generateRandomChars(13));
        } else {
            int accountLockout = ConfigManager.admin.getAccountLockoutValue();
            int accountLockoutLimit = ConfigManager.admin.getAccountLockoutThreshold();
            boolean isValidateAcctLockout = ConfigManager.admin.isValidateAcctLockout();
            int accountLockoutDurationMinutes = ConfigManager.admin.getAccountLockoutDurationMinutes();
            if (isValidateAcctLockout) {
                int invalidLoginCount = accessUser.getInvalidLogonCount();
                invalidLoginCount = invalidLoginCount == accountLockout ? 1 : ++invalidLoginCount;
                if (invalidLoginCount >= accountLockoutLimit) {
                    invalidLoginCount = accountLockout;
                    errors.add("login", new ActionMessage("auth.login.error.accountLocked"));
                } else {
                    errors.add("login", new ActionMessage("auth.login.error.wrongCredentialLimit", accountLockoutDurationMinutes, accountLockoutLimit - invalidLoginCount));
                }
                authDao.updateUserInvalidLogon(accessUser, invalidLoginCount);
            } else {
                errors.add("login", new ActionMessage("auth.login.error.wrongCredential"));
            }
        }
        return errors;
    }

    public ActionMessages testLdapConnection(String urlScheme, String url, String username, String password, String securityPrincipal) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("ldapUrl").setTitleKey("admin.config.auth.ldapUrl").calculateLength(url).setNullable(false));
        validator.validate(new ColumnField().setName("ldapUsername").setTitleKey("common.column.username").calculateLength(username).setNullable(false));
        validator.validate(new ColumnField().setName("ldapPassword").setTitleKey("common.column.user_password").calculateLength(password).setNullable(false));
        if (!errors.isEmpty()) {
            return errors;
        }
        AccessUser appUser = new AccessUser();
        appUser.setUsername(username);
        appUser.setHashedPassword(password);
        try {
            AuthDao authDao = new AuthDao(this.requestContext);
            errors = authDao.isValidUsername(appUser);
        }
        catch (UsernameNotFoundException e) {
            errors.add("invalidUsername", new ActionMessage("admin.config.auth.ldap.error.invalidUsername"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        if (appUser.isAccountDisabled()) {
            errors.add("accountDisabled", new ActionMessage("admin.config.auth.ldap.error.accountDisabled"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        Ldap ldap = new Ldap();
        ldap.setProtocol(urlScheme);
        ldap.setUrl(url);
        ldap.setUsername(username);
        ldap.setSecurityPrincipal(securityPrincipal);
        ldap.setPassword(password);
        return ldap.authenticate();
    }

    public boolean isValidBasicAuthentication(AccessUser user) throws Exception {
        String authHeaderRequest = this.requestContext.getRequest().getHeader("authorization");
        if (authHeaderRequest == null) {
            return false;
        }
        String authHeader = StringUtils.decodeBase64(authHeaderRequest.replaceFirst("Basic ", ""));
        String[] credential = authHeader.split(":");
        if (credential.length != 2) {
            return false;
        }
        user.setUsername(credential[0]);
        user.setRequestedPassword(credential[1]);
        return this.authenticateUser(user).isEmpty();
    }

    public void initializeUserSession(HttpServletRequest request, HttpServletResponse response, AccessUser user) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("SESSION_LOCALE");
        String theme = (String)session.getAttribute("SESSION_THEME");
        session.invalidate();
        session = request.getSession();
        session.setMaxInactiveInterval(ConfigManager.auth.getSessionTimeoutSeconds());
        if (locale != null) {
            session.setAttribute("SESSION_INIT", (Object)true);
            session.setAttribute("SESSION_LOCALE", (Object)locale);
        }
        if (theme != null) {
            session.setAttribute("SESSION_THEME", (Object)theme);
        }
        CookieManager.setUserId(response, String.valueOf(user.getId()));
        CookieManager.setSessionToken(response, user.getSessionToken());
    }
}

