/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.auth.core;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.dto.AccessPage;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.exceptions.AjaxAuthenticationRequiredException;
import com.kwoksys.framework.exceptions.AuthenticationRequiredException;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.session.CookieManager;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.UrlUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Set;

public class Access {
    public static final Integer ADMIN_USER_ID = 1;
    public static final Integer GUEST_USER_ID = -1001;
    public static final String AUTH_APP = "app";
    public static final String AUTH_LDAP = "ldap";
    public static final String AUTH_MIXED = "mixed";
    private static final Set<String> publicPagesMap = new HashSet<String>();
    private static final Set<String> issuesGuestSubmitPages = new HashSet<String>();
    public static final AccessUser GUESS_USER = new AccessUser(GUEST_USER_ID);

    public static boolean isPublicPage(String path) {
        return publicPagesMap.contains(path);
    }

    public static boolean hasSpecialPagePermission(AccessUser accessUser, String pageName) {
        if (issuesGuestSubmitPages.contains(pageName)) {
            return FeatureManager.isIssueGuestSubmitFooterEnabled() || FeatureManager.isIssueGuestSubmitModuleEnabled(accessUser);
        }
        return false;
    }

    public static boolean hasPermission(AccessUser user, Integer permId) throws DatabaseException {
        if (Access.isDefaultAdmin(user.getId())) {
            return true;
        }
        Set<Integer> permSet = Access.getEffectivePermissions(user);
        return permSet.contains(permId);
    }

    public static boolean hasPermission(AccessUser user, String pageName) throws DatabaseException {
        if (user == null) {
            return false;
        }
        if (Access.isPublicPage(pageName) || Access.hasSpecialPagePermission(user, pageName)) {
            return true;
        }
        AccessPage accessPage = Access.getAccessPage(pageName);
        if (accessPage == null) {
            return false;
        }
        if (Access.isDefaultAdmin(user.getId())) {
            return true;
        }
        Set<Integer> permSet = Access.getEffectivePermissions(user);
        for (Integer permId : permSet) {
            Set<Integer> set = Access.getCachedPermissionPages(permId);
            if (set == null || !set.contains(accessPage.getPageId())) continue;
            return true;
        }
        return false;
    }

    private static Set<Integer> getEffectivePermissions(AccessUser user) throws DatabaseException {
        if (user.getGroupId() != 0) {
            return new CacheManager().getGroupPermissionsCache(user.getGroupId());
        }
        return new CacheManager().getUserPermissionsCache(user.getId());
    }

    public static AccessPage getAccessPage(String pageName) throws DatabaseException {
        return new CacheManager().getPagesInfoCache().get(pageName);
    }

    private static Set<Integer> getCachedPermissionPages(Integer permissionId) throws DatabaseException {
        return new CacheManager().getPermissionPagesCache().get(permissionId);
    }

    public static AccessUser getCookieUser(Cookie[] cookies) {
        Integer cookieUserId = NumberUtils.replaceNull(CookieManager.getUserId(cookies), GUEST_USER_ID);
        return new AccessUser(cookieUserId);
    }

    public static boolean isDefaultAdmin(Integer userId) {
        return userId.equals(ADMIN_USER_ID);
    }

    public static void requestCredential(RequestContext requestContext, ResponseContext responseContext, String errorCode) throws Exception {
        HttpServletRequest request = requestContext.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append(AppPaths.ROOT + AppPaths.HOME_INDEX).append("?redirectPath=");
        if (!(AppPaths.AUTH_LOGOUT.equals(requestContext.getPageName()) || request.getMethod().equals("POST") || requestContext.getPageName().contains("/ajax-"))) {
            String queryString = request.getQueryString();
            if (queryString != null) {
                queryString = queryString.replace("&_ajax=true", "");
                queryString = queryString.replace("_ajax=true", "");
            }
            sb.append(UrlUtils.encode(UrlUtils.formatQueryString(requestContext.getPageName(), queryString)));
        }
        sb.append("&errorCode=").append(errorCode).append("&").append("_error=true");
        if (requestContext.isAjax()) {
            throw new AjaxAuthenticationRequiredException(sb.toString());
        }
        responseContext.getResponse().sendRedirect(sb.toString());
    }

    public static void requestBasicAuthCredential(RequestContext requestContext, ResponseContext responseContext) throws Exception {
        String realm = ConfigManager.system.getCompanyName().isEmpty() ? Localizer.getText(requestContext, "common.app.name") : ConfigManager.system.getCompanyName();
        responseContext.getResponse().setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        throw new AuthenticationRequiredException();
    }

    static {
        publicPagesMap.add(AppPaths.AUTH_LOGOUT);
        publicPagesMap.add(AppPaths.AUTH_VERIFY);
        publicPagesMap.add(AppPaths.HOME_INDEX);
        publicPagesMap.add(AppPaths.HOME_UNAUTHORIZED);
        publicPagesMap.add(AppPaths.HOME_FORBIDDEN);
        publicPagesMap.add(AppPaths.HOME_FILE_NOT_FOUND);
        publicPagesMap.add(AppPaths.HOME_OBJECT_NOT_FOUND);
        publicPagesMap.add(AppPaths.HOME_NON_SUPPORTED_BROWSER);
        issuesGuestSubmitPages.add(AppPaths.ISSUE_PLUGIN_ADD);
        issuesGuestSubmitPages.add(AppPaths.ISSUE_PLUGIN_ADD_2);
        issuesGuestSubmitPages.add(AppPaths.ISSUE_PLUGIN_ADD_3);
        issuesGuestSubmitPages.add(AppPaths.ISSUE_PLUGIN_LEGEND_DETAIL);
    }
}

