/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.auth.core;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.AuthUtils;
import com.kwoksys.biz.auth.dao.AuthDao;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.ldap.Ldap;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.UsernameNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.license.LicenseManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuthManager {
    private static final Logger LOGGER = Logger.getLogger(AuthManager.class.getName());
    private AccessUser accessUser;
    private RequestContext requestContext;
    private ActionMessages errors = new ActionMessages();

    public AuthManager(RequestContext requestContext, AccessUser accessUser) {
        this.requestContext = requestContext;
        this.accessUser = accessUser;
    }

    public ActionMessages validateCredentialFormat() {
        if (this.accessUser.getUsername().isEmpty()) {
            this.errors.add("emptyUsername", new ActionMessage("auth.login.error.emptyUsername"));
        } else if (this.accessUser.getRequestedPassword().isEmpty()) {
            this.errors.add("emptyPassword", new ActionMessage("auth.login.error.emptyPassword"));
        }
        return this.errors;
    }

    public ActionMessages validateUserName() throws DatabaseException {
        try {
            AuthDao authDao = new AuthDao(this.requestContext);
            this.errors = authDao.isValidUsername(this.accessUser);
        }
        catch (UsernameNotFoundException e) {
            this.errors.add("noUsernameFound", new ActionMessage("auth.login.error.wrongCredential"));
            LOGGER.warning(LogConfigManager.AUTHENTICATION_PREFIX + " Login failed for user: " + this.accessUser.getUsername() + ". No such username in application.");
        }
        return this.errors;
    }

    public ActionMessages validateUserStatus() {
        int accountLockout = ConfigManager.admin.getAccountLockoutValue();
        long accountLockoutMs = ConfigManager.admin.getAccountLockoutDurationMs();
        boolean isValidateAcctLockout = ConfigManager.admin.isValidateAcctLockout();
        if (this.accessUser.isAccountDisabled()) {
            this.errors.add("accountDisabled", new ActionMessage("auth.login.error.accountDisabled"));
            LOGGER.warning(LogConfigManager.AUTHENTICATION_PREFIX + " Login failed for user: " + this.accessUser.getUsername() + ". Account disabled in application.");
        } else if (this.accessUser.isGuessUser()) {
            this.errors.add("noGuestUser", new ActionMessage("auth.login.error.noGuestUser"));
        } else {
            Date sysdate = this.requestContext.getSysdate();
            if (isValidateAcctLockout && this.accessUser.getInvalidLogonCount() == accountLockout && this.accessUser.getInvalidLogonDate().getTime() > sysdate.getTime() - accountLockoutMs) {
                this.errors.add("login", new ActionMessage("auth.login.error.accountLocked"));
            }
        }
        return this.errors;
    }

    public boolean authenticateDbUser() throws Exception {
        LOGGER.log(Level.INFO, LogConfigManager.AUTHENTICATION_PREFIX + " Validating database user: " + this.accessUser.getUsername());
        boolean isValidLogin = AuthUtils.hashPassword(this.accessUser.getRequestedPassword()).equals(this.accessUser.getHashedPassword());
        if (!isValidLogin && !ConfigManager.auth.isLdapAuthEnabled()) {
            LOGGER.warning(LogConfigManager.AUTHENTICATION_PREFIX + " Login failed for user: " + this.accessUser.getUsername() + ". Wrong password.");
        }
        return isValidLogin;
    }

    public boolean authenticateLdapUser() {
        LOGGER.log(Level.INFO, LogConfigManager.AUTHENTICATION_PREFIX + " Validating LDAP user: " + this.accessUser.getUsername());
        Ldap ldap = new Ldap();
        ldap.setProtocol(ConfigManager.auth.getLdapUrlScheme());
        ldap.setUrl(ConfigManager.auth.getAuthLdapUrl());
        ldap.setUsername(this.accessUser.getUsername());
        ldap.setSecurityPrincipal(ConfigManager.auth.getAuthLdapSecurityPrincipal());
        ldap.setPassword(this.accessUser.getRequestedPassword());
        return ldap.authenticate().isEmpty();
    }

    public boolean isConcurrentUsersLimitExceeded(AccessUser accessUser) throws DatabaseException {
        if (LicenseManager.isCommercialEdition() || accessUser.getId().equals(Access.ADMIN_USER_ID)) {
            return false;
        }
        UserSearch userSearch = new UserSearch();
        userSearch.put("loggedInUsers", "");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        return adminService.getUserCount(new QueryCriteria(userSearch)) > 0;
    }

    public AccessUser getAccessUser() {
        return this.accessUser;
    }

    public ActionMessages getErrors() {
        return this.errors;
    }
}

