/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.auth.core;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.framework.exceptions.DatabaseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IssueAccess {
    private boolean hasReadAllPermission;
    private Set<Integer> allowedObjects = new HashSet<Integer>();

    public IssueAccess(AccessUser accessUser) throws DatabaseException {
        this.hasReadAllPermission = accessUser.hasPermission(1);
    }

    public boolean hasReadAllPermission() {
        return this.hasReadAllPermission;
    }

    public boolean hasPermission(Integer objectId) {
        return this.hasReadAllPermission || this.allowedObjects.contains(objectId);
    }

    public void setAllowedIssues(Set<Integer> allowedObjects) {
        this.allowedObjects = allowedObjects;
    }

    public void setAllowedIssues(List<Issue> issues) {
        if (issues != null) {
            for (Issue issue : issues) {
                this.allowedObjects.add(issue.getId());
            }
        }
    }
}

