/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.auth.dao;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.dao.AuthQueries;
import com.kwoksys.biz.auth.dto.AccessPage;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.UsernameNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthDao
extends BaseDao {
    public AuthDao(RequestContext requestContext) {
        super(requestContext);
    }

    public Map<Integer, Set<Integer>> getAccessPermPages() throws DatabaseException {
        final HashMap<Integer, Set<Integer>> permMap = new HashMap<Integer, Set<Integer>>();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.selectPermPages()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Integer permId = rs.getInt("perm_id");
                Integer pageId = rs.getInt("page_id");
                HashSet<Integer> pageSet = (HashSet<Integer>)permMap.get(permId);
                if (pageSet == null) {
                    pageSet = new HashSet<Integer>();
                    permMap.put(permId, pageSet);
                }
                pageSet.add(pageId);
            }
        };
        this.executeQuery(queryHelper);
        return permMap;
    }

    public Set<Integer> getAccessGroupPerms(Integer groupId) throws DatabaseException {
        final HashSet<Integer> permSet = new HashSet<Integer>();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.selectGroupPerms()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                permSet.add(rs.getInt("perm_id"));
            }
        };
        queryHelper.addInputInt(groupId);
        this.executeQuery(queryHelper);
        return permSet;
    }

    public Set<Integer> getAccessUserPerms(Integer userId) throws DatabaseException {
        final HashSet<Integer> permSet = new HashSet<Integer>();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.selectUserPerms()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                permSet.add(rs.getInt("perm_id"));
            }
        };
        queryHelper.addInputInt(userId);
        this.executeQuery(queryHelper);
        return permSet;
    }

    public Map<String, AccessPage> getAccessPages() throws DatabaseException {
        final HashMap<String, AccessPage> map = new HashMap<String, AccessPage>();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.selectAccessPages()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                AccessPage page = new AccessPage();
                page.setPageId(rs.getInt("page_id"));
                page.setModuleId(rs.getInt("module_id"));
                page.setPath(rs.getString("page_name") + ConfigManager.system.getExtension());
                map.put(page.getPath(), page);
            }
        };
        this.executeQuery(queryHelper);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages updateUserLogonSession(AccessUser accessUser, String sessionToken) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.updateUserLogonSessionQuery());
        queryHelper.addInputStringConvertNull(sessionToken);
        queryHelper.addInputInt(accessUser.getId());
        try {
            queryHelper.executeProcedure(conn);
            accessUser.setSessionToken(sessionToken);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages updateUserInvalidLogon(AccessUser accessUser, int invalidLogonCount) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AuthQueries.updateUserInvalidLogonQuery());
        queryHelper.addInputInt(accessUser.getId());
        queryHelper.addInputInt(invalidLogonCount);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages updateUserLogoutSession(Integer userId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(AuthQueries.updateUserLogoutSessionQuery());
        queryHelper.addInputInt(userId);
        return this.executeProcedure(queryHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidUserSession(Integer userId, String sessionTokenCookie) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.validateUserSessionQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(userId);
        queryHelper.addInputString(sessionTokenCookie);
        queryHelper.addInputInt(ConfigManager.auth.getSessionTimeoutSeconds());
        try {
            queryHelper.executeProcedure(conn);
            boolean bl = !queryHelper.getSqlOutputs().get(0).equals(0);
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public ActionMessages isValidUsername(final AccessUser user) throws DatabaseException, UsernameNotFoundException {
        final ArrayList users = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(AuthQueries.selectValidUsernameQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                user.setId(rs.getInt("user_id"));
                user.setHashedPassword(StringUtils.replaceNull(rs.getString("password")));
                user.setStatus(rs.getInt("status"));
                user.setInvalidLogonCount(rs.getInt("invalid_logon_count"));
                user.setInvalidLogonDate(DatetimeUtils.getDate(rs, "invalid_logon_date"));
                users.add(user);
            }
        };
        queryHelper.addInputString(user.getUsername());
        try {
            this.executeSingleRecordQuery(queryHelper);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        if (this.errors.isEmpty() && users.isEmpty()) {
            throw new UsernameNotFoundException();
        }
        return this.errors;
    }
}

