/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.base;

import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.DatabaseManager;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseDao {
    private static final Logger LOGGER = Logger.getLogger(BaseDao.class.getName());
    protected RequestContext requestContext;
    private DatabaseManager databaseManager;
    protected final ActionMessages errors = new ActionMessages();

    public BaseDao(RequestContext requestContext) {
        this.requestContext = requestContext;
        this.databaseManager = DatabaseManager.getInstance();
    }

    public Connection getConnection() throws DatabaseException {
        return this.databaseManager.createConnection();
    }

    public void closeConnection(Connection conn) {
        this.databaseManager.closeConnection(conn, !this.errors.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionMessages executeProcedure(QueryHelper queryHelper) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            queryHelper.executeProcedure(conn);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionMessages executeUpdate(QueryHelper queryHelper) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            queryHelper.executeUpdate(conn);
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public void executeQuery(QueryHelper queryHelper) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            ResultSet rs = queryHelper.executeQuery(conn);
            while (rs.next()) {
                queryHelper.callback(rs);
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e, queryHelper);
        }
        finally {
            queryHelper.close();
            this.closeConnection(conn);
        }
    }

    public void executeSingleRecordQuery(QueryHelper queryHelper) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            ResultSet rs = queryHelper.executeQuery(conn);
            if (rs.next()) {
                queryHelper.callback(rs);
            }
        }
        catch (Exception e) {
            throw new DatabaseException(e, queryHelper);
        }
        finally {
            queryHelper.close();
            this.closeConnection(conn);
        }
    }

    public List<Map<String, String>> executeQueryReturnList(QueryHelper queryHelper) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            List<Map<String, String>> list = queryHelper.executeQueryReturnList(conn);
            return list;
        }
        catch (Exception e) {
            throw new DatabaseException(e, queryHelper);
        }
        finally {
            queryHelper.close();
            this.closeConnection(conn);
        }
    }

    public int getRowCount(String sql) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(sql);
        try {
            ResultSet rs = queryHelper.executeQuery(conn);
            rs.next();
            int n = rs.getInt("row_count");
            return n;
        }
        catch (Exception e) {
            throw new DatabaseException(e, queryHelper);
        }
        finally {
            queryHelper.close();
            this.closeConnection(conn);
        }
    }

    public void handleError(Exception e) {
        if (!(e instanceof DatabaseException) || ((DatabaseException)e).getQueryHelper() == null) {
            LOGGER.log(Level.SEVERE, LogConfigManager.DATABASE_ACCESS_PREFIX + " Problem executing SQL statement", e);
        }
        this.errors.add("database", new ActionMessage("common.error.database"));
    }
}

