/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.base;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeValue;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class BaseObject
implements Serializable {
    public static final String ROWNUM = "rownum";
    public static final String CREATOR_NAME = "creator_name";
    public static final String CREATION_DATE = "creation_date";
    public static final String MODIFIER_NAME = "modifier_name";
    public static final String MODIFICATION_DATE = "modification_date";
    public static final String REL_DESCRIPTION = "relationship_description";
    private Integer id;
    private Integer creatorId;
    private AccessUser creator;
    private Date creationDate;
    private Integer modifierId;
    private AccessUser modifier;
    private Date modificationDate;
    private Map<Integer, Attribute> attributes;
    private String relDescription;
    private Integer objectTypeId;
    private Map<Integer, AttributeValue> customValues = new LinkedHashMap<Integer, AttributeValue>();

    public BaseObject() {
    }

    public BaseObject(Integer objectTypeId) {
        this.objectTypeId = objectTypeId;
    }

    public boolean isAttrEmpty(String attrName) {
        return false;
    }

    public void loadAttrs(RequestContext requestContext) {
        this.attributes = new AttributeManager(requestContext).getSystemAttributes(this);
    }

    public boolean isAttrRequired(String attrName) {
        return this.attributes.get(Attributes.getNameIdMap().get(attrName)).isRequired();
    }

    public String getAttrRequiredText(String attrName) {
        return this.isAttrRequired(attrName) ? Image.getInstance().getRequiredField() : "";
    }

    public String getCreationDate() {
        return DatetimeUtils.toLocalDatetime(this.creationDate);
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getModificationDate() {
        return DatetimeUtils.toLocalDatetime(this.modificationDate);
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public AccessUser getCreator() {
        return this.creator;
    }

    public void setCreator(AccessUser creator) {
        this.creator = creator;
    }

    public AccessUser getModifier() {
        return this.modifier;
    }

    public void setModifier(AccessUser modifier) {
        this.modifier = modifier;
    }

    public Integer getObjectTypeId() {
        return this.objectTypeId;
    }

    public void setObjectTypeId(Integer objectTypeId) {
        this.objectTypeId = objectTypeId;
    }

    public String getRelDescription() {
        return this.relDescription;
    }

    public void setRelDescription(String relDescription) {
        this.relDescription = relDescription;
    }

    public Map<Integer, AttributeValue> getCustomValues() {
        return this.customValues;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public Integer getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(Integer modifierId) {
        this.modifierId = modifierId;
    }
}

