/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.blogs;

import com.kwoksys.biz.blogs.dao.BlogDao;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.blogs.dto.BlogPostComment;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dao.CategoryDao;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.List;

public class BlogService {
    private RequestContext requestContext;

    public BlogService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Category> getCategories(QueryCriteria query) throws DatabaseException {
        return new CategoryDao(this.requestContext).getCategoryList(query, ObjectTypes.BLOG_POST);
    }

    public Category getCategory(Integer categoryId) throws DatabaseException, ObjectNotFoundException {
        return new CategoryDao(this.requestContext).getCategory(categoryId, ObjectTypes.BLOG_POST);
    }

    public ActionMessages addCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CategoryDao(this.requestContext).addCategory(category);
    }

    public ActionMessages updateCategory(Category category) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (category.getName().isEmpty()) {
            errors.add("categoryName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.category_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CategoryDao(this.requestContext).editCategory(category);
    }

    public List<BlogPost> getPosts(QueryCriteria query) throws DatabaseException {
        return new BlogDao(this.requestContext).getPostList(query);
    }

    public int getPostCount(QueryCriteria query) throws DatabaseException {
        return new BlogDao(this.requestContext).getPostCount(query);
    }

    public BlogPost getPost(Integer postId) throws DatabaseException, ObjectNotFoundException {
        return new BlogDao(this.requestContext).getPost(postId);
    }

    public ActionMessages addPost(BlogPost post) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (post.getPostTitle().isEmpty()) {
            errors.add("postTitle", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.post_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new BlogDao(this.requestContext).addPost(post);
    }

    public ActionMessages editPost(BlogPost post) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (post.getPostTitle().isEmpty()) {
            errors.add("postTitle", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.post_name")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new BlogDao(this.requestContext).editPost(post);
    }

    public ActionMessages deletePost(BlogPost post) throws DatabaseException {
        return new BlogDao(this.requestContext).deletePost(post);
    }

    public List<BlogPostComment> getPostComments(QueryCriteria query, Integer postId) throws DatabaseException {
        return new BlogDao(this.requestContext).getPostCommentList(query, postId);
    }

    public ActionMessages addPostComment(BlogPostComment comment) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (comment.getCommentDescription().isEmpty()) {
            errors.add("emptyDescription", new ActionMessage("blogs.postDetail.error.emptyDescription"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new BlogDao(this.requestContext).addPostComment(comment);
    }
}

