/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.blogs.core;

import com.kwoksys.action.blogs.PostSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;

public class BlogPostSearch
extends BaseSearch {
    public BlogPostSearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public BlogPostSearch() {
    }

    public void prepareMap(PostSearchForm postSearchForm) {
        String cmd = this.requestContext.getParameterString("cmd");
        if (!cmd.isEmpty()) {
            this.reset();
            postSearchForm.setRequest(this.requestContext);
            if (!cmd.equals("showAll") && cmd.equals("search")) {
                Integer categoryId;
                int postAllowComment;
                String postDescription;
                String postTitle = postSearchForm.getPostTitle();
                if (!postTitle.isEmpty()) {
                    this.searchCriteriaMap.put("postTitleContains", postTitle);
                }
                if (!(postDescription = postSearchForm.getPostDescription()).isEmpty()) {
                    this.searchCriteriaMap.put("postDescriptionContains", postDescription);
                }
                if ((postAllowComment = postSearchForm.getPostAllowComment()) != -1) {
                    this.searchCriteriaMap.put("postAllowComment", postAllowComment);
                }
                if ((categoryId = postSearchForm.getCategoryId()) != 0) {
                    this.searchCriteriaMap.put("categoryId", categoryId);
                }
            }
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap.isEmpty()) {
            return;
        }
        if (this.searchCriteriaMap.containsKey("postTypeEquals")) {
            query.appendWhereClause("p.post_type = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("postTypeEquals")));
        }
        if (this.searchCriteriaMap.containsKey("postTitleContains")) {
            query.appendWhereClause("lower(p.post_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("postTitleContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("postDescriptionContains")) {
            query.appendWhereClause("lower(p.post_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("postDescriptionContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("postAllowComment")) {
            query.appendWhereClause("p.post_allow_comment = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("postAllowComment")));
        }
        if (this.searchCriteriaMap.containsKey("categoryId")) {
            query.appendWhereClause("p.category_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("categoryId")));
        }
    }
}

