/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.blogs.dao;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.blogs.dto.BlogPostComment;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class BlogDao
extends BaseDao {
    public BlogDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<BlogPost> getPostList(QueryCriteria query) throws DatabaseException {
        final ArrayList<BlogPost> posts = new ArrayList<BlogPost>();
        QueryHelper queryHelper = new QueryHelper(BlogQueries.selectBlogPostListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                BlogPost post = new BlogPost();
                post.setId(rs.getInt("post_id"));
                post.setPostTitle(StringUtils.replaceNull(rs.getString("post_name")));
                post.setPostBody(StringUtils.replaceNull(rs.getString("post_description")));
                post.setPostType(rs.getInt("post_type"));
                post.setPostIp(StringUtils.replaceNull(rs.getString("post_ip")));
                post.setPostCommentCount(rs.getInt("comment_count"));
                post.setCategoryId(rs.getInt("category_id"));
                post.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                post.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                post.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                post.setCreator(new AccessUser());
                post.getCreator().setId(rs.getInt("creator"));
                post.getCreator().setUsername(rs.getString("creator_username"));
                post.getCreator().setDisplayName(rs.getString("creator_display_name"));
                post.setModifier(new AccessUser());
                post.getModifier().setId(rs.getInt("modifier"));
                post.getModifier().setUsername(rs.getString("modifier_username"));
                post.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                posts.add(post);
            }
        };
        this.executeQuery(queryHelper);
        return posts;
    }

    public int getPostCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(BlogQueries.getBlogPostCountQuery(query));
    }

    public BlogPost getPost(Integer postId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList list = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(BlogQueries.selectBlogPostDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                BlogPost post = new BlogPost();
                post.setId(rs.getInt("post_id"));
                post.setPostTitle(StringUtils.replaceNull(rs.getString("post_name")));
                post.setPostBody(StringUtils.replaceNull(rs.getString("post_description")));
                post.setPostType(rs.getInt("post_type"));
                post.setPostIp(StringUtils.replaceNull(rs.getString("post_ip")));
                post.setPostAllowComment(rs.getInt("post_allow_comment"));
                post.setCategoryId(rs.getInt("category_id"));
                post.setCategoryName(StringUtils.replaceNull(rs.getString("category_name")));
                post.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                post.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                post.setPostCommentCount(rs.getInt("comment_count"));
                post.setCreator(new AccessUser());
                post.getCreator().setId(rs.getInt("creator"));
                post.getCreator().setUsername(rs.getString("creator_username"));
                post.getCreator().setDisplayName(rs.getString("creator_display_name"));
                post.setModifier(new AccessUser());
                post.getModifier().setId(rs.getInt("modifier"));
                post.getModifier().setUsername(rs.getString("modifier_username"));
                post.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                list.add(post);
            }
        };
        queryHelper.addInputInt(postId);
        this.executeSingleRecordQuery(queryHelper);
        if (!list.isEmpty()) {
            return (BlogPost)list.get(0);
        }
        throw new ObjectNotFoundException("Post ID: " + postId);
    }

    public List<BlogPostComment> getPostCommentList(QueryCriteria query, Integer postId) throws DatabaseException {
        final ArrayList<BlogPostComment> comments = new ArrayList<BlogPostComment>();
        QueryHelper queryHelper = new QueryHelper(BlogQueries.selectBlogPostCommentListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                BlogPostComment comment = new BlogPostComment();
                comment.setCommentId(rs.getInt("comment_id"));
                comment.setCommentDescription(StringUtils.replaceNull(rs.getString("comment_description")));
                comment.setCommentIp(StringUtils.replaceNull(rs.getString("comment_ip")));
                comment.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                comment.setCreator(new AccessUser());
                comment.getCreator().setId(rs.getInt("creator"));
                comment.getCreator().setUsername(rs.getString("creator_username"));
                comment.getCreator().setDisplayName(rs.getString("creator_display_name"));
                comments.add(comment);
            }
        };
        queryHelper.addInputInt(postId);
        this.executeQuery(queryHelper);
        return comments;
    }

    public ActionMessages addPost(BlogPost post) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BlogQueries.insertBlogPostQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(post.getPostTitle());
        queryHelper.addInputStringConvertNull(post.getPostBody());
        queryHelper.addInputInt(post.getPostType());
        queryHelper.addInputStringConvertNull(post.getPostIp());
        queryHelper.addInputInt(post.getPostAllowComment());
        queryHelper.addInputInt(post.getCategoryId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            post.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages editPost(BlogPost post) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BlogQueries.updateBlogPostQuery());
        queryHelper.addInputInt(post.getId());
        queryHelper.addInputStringConvertNull(post.getPostTitle());
        queryHelper.addInputStringConvertNull(post.getPostBody());
        queryHelper.addInputInt(post.getPostType());
        queryHelper.addInputInt(post.getPostAllowComment());
        queryHelper.addInputInt(post.getCategoryId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deletePost(BlogPost post) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BlogQueries.deleteBlogPostQuery());
        queryHelper.addInputInt(post.getId());
        queryHelper.addInputInt(post.getCategoryId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages addPostComment(BlogPostComment comment) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(BlogQueries.insertBlogPostCommentQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(comment.getCommentDescription());
        queryHelper.addInputStringConvertNull(comment.getCommentIp());
        queryHelper.addInputInt(comment.getPostId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            comment.setCommentId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }
}

