/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.core.CompanySearch;
import com.kwoksys.biz.contacts.dao.CompanyBookmarkDao;
import com.kwoksys.biz.contacts.dao.CompanyContactDao;
import com.kwoksys.biz.contacts.dao.CompanyDao;
import com.kwoksys.biz.contacts.dao.CompanyNoteDao;
import com.kwoksys.biz.contacts.dao.ContactDao;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.CompanyBookmark;
import com.kwoksys.biz.contacts.dto.CompanyNote;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.BookmarkService;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.biz.system.dto.linking.CompanyIssueLink;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.List;
import java.util.Map;

public class ContactService {
    private RequestContext requestContext;

    public ContactService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Company> getCompanies(QueryCriteria query) throws DatabaseException {
        return new CompanyDao(this.requestContext).getCompanies(query, null);
    }

    public int getCompanyCount(QueryCriteria query) throws DatabaseException {
        return new CompanyDao(this.requestContext).getCount(query);
    }

    public Company getCompany(Integer companyId) throws DatabaseException, ObjectNotFoundException {
        return new CompanyDao(this.requestContext).getCompany(companyId);
    }

    public List<Integer> getCompanyTypes(Integer companyId) throws DatabaseException {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("attributeIdEquals", Attributes.COMPANY_TYPES);
        attributeSearch.put("objectId", companyId);
        QueryCriteria query = new QueryCriteria(attributeSearch);
        return new CompanyDao(this.requestContext).getCompanyTypes(query);
    }

    private void validateCompanyTags(ActionMessages errors, Company company) {
        if (!company.getTags().isEmpty()) {
            if (!company.isValidTagFormat()) {
                errors.add("invalidTagFormat", new ActionMessage("contactMgmt.companyAdd.error.invalidTagFormat"));
            } else if (company.getCompanyTagsCommaSeparated().length > company.numTagsAllowed()) {
                errors.add("tooManyTags", new ActionMessage("contactMgmt.companyAdd.error.tooManyTags"));
            }
        }
    }

    public ActionMessages addCompany(Company company, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("companyName").setTitleKey("common.column.company_name").calculateLength(company.getName()).setColumnName("company.company_name").setNullable(false));
        this.validateCompanyTags(errors, company);
        validator.validateAttrs(company, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CompanyDao(this.requestContext).add(company);
    }

    public ActionMessages updateCompany(Company company, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("companyName").setTitleKey("common.column.company_name").calculateLength(company.getName()).setColumnName("company.company_name").setNullable(false));
        this.validateCompanyTags(errors, company);
        validator.validateAttrs(company, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CompanyDao(this.requestContext).update(company);
    }

    public ActionMessages deleteCompany(Company company) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (company.getId() == 0) {
            errors.add("emptyCompanyId", new ActionMessage("contactMgmt.error.emptyCompanyId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        List<File> deleteFileList = this.getCompanyFiles(new QueryCriteria(), company.getId());
        errors = new CompanyDao(this.requestContext).delete(company);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getCompanyFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public Company getSingleCompanyByName(String companyName) throws DatabaseException {
        CompanySearch companySearch = new CompanySearch();
        companySearch.put("companyNameEquals", companyName);
        QueryCriteria queryCriteria = new QueryCriteria(companySearch);
        queryCriteria.setLimit(2, 0);
        List<Company> companyList = this.getCompanies(queryCriteria);
        if (companyList.size() == 1) {
            return companyList.get(0);
        }
        return null;
    }

    public List<File> getCompanyFiles(QueryCriteria query, Integer companyId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(query, ObjectTypes.COMPANY, companyId);
    }

    public ActionMessages resetCompanyFileCount(Integer companyId) throws DatabaseException {
        return new CompanyDao(this.requestContext).resetFileCount(companyId);
    }

    public File getCompanyFile(Integer companyId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.COMPANY, companyId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getCompanyFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getCompanyUploadedFilePrefix());
        return file;
    }

    public List<Map<String, String>> getCompanyTags(QueryCriteria query, Integer companyId) throws DatabaseException {
        return new CompanyDao(this.requestContext).getTagList(query, companyId);
    }

    public List<Map<String, String>> getExistingCompanyTags(QueryCriteria query) throws DatabaseException {
        return new CompanyDao(this.requestContext).getExistingTagList(query);
    }

    public List<CompanyNote> getCompanyNotes(QueryCriteria query, Integer companyId) throws DatabaseException {
        return new CompanyNoteDao(this.requestContext).getNoteList(query, companyId);
    }

    public ActionMessages addCompanyNote(CompanyNote note) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (note.getNoteName().isEmpty()) {
            errors.add("noteName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.company_note_name")));
        }
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validateAttrs(note, null);
        if (!errors.isEmpty()) {
            return errors;
        }
        CompanyNoteDao companyNoteDao = new CompanyNoteDao(this.requestContext);
        return companyNoteDao.addNote(note);
    }

    public ActionMessages resetCompanyNoteCount(Integer companyId) throws DatabaseException {
        CompanyDao companyDao = new CompanyDao(this.requestContext);
        return companyDao.resetNoteCount(companyId);
    }

    public List<Bookmark> getCompanyBookmarks(QueryCriteria query, Integer companyId) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.getBookmarks(query, ObjectTypes.COMPANY, companyId);
    }

    public Bookmark getCompanyBookmark(Integer companyId, Integer bookmarkId) throws DatabaseException, ObjectNotFoundException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.getBookmark(ObjectTypes.COMPANY, companyId, bookmarkId);
    }

    public ActionMessages addCompanyBookmark(CompanyBookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.addBookmark(bookmark);
    }

    public ActionMessages updateCompanyBookmark(Bookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.updateBookmark(bookmark);
    }

    public ActionMessages deleteCompanyBookmark(Bookmark bookmark) throws DatabaseException {
        BookmarkService bookmarkService = ServiceProvider.getBookmarkService(this.requestContext);
        return bookmarkService.deleteBookmark(bookmark);
    }

    public ActionMessages resetCompanyBookmarkCount(Integer companyId) throws DatabaseException {
        CompanyBookmarkDao companyBookmarkDao = new CompanyBookmarkDao(this.requestContext);
        return companyBookmarkDao.resetCount(companyId);
    }

    public List<Contact> getCompanyContacts(QueryCriteria query, Integer companyId, Integer companyContactType) throws DatabaseException {
        return new CompanyContactDao(this.requestContext).getList(query, companyId, companyContactType);
    }

    public ActionMessages addCompanyContact(Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contact.getTitle().isEmpty()) {
            errors.add("contactTitle", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_main_label")));
        }
        if (contact.getCompanyId() == 0) {
            errors.add("emptyCompanyId", new ActionMessage("contactMgmt.companyContactEdit.error.emptyCompanyId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CompanyContactDao(this.requestContext).addCompanyContact(contact);
    }

    public ActionMessages updateCompanyContact(Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contact.getTitle().isEmpty()) {
            errors.add("contactTitle", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_main_label")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CompanyContactDao(this.requestContext).updateCompanyContact(contact);
    }

    public ActionMessages addEmployeeContact(Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contact.getFirstName().isEmpty()) {
            errors.add("contactFirstName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_first_name")));
        }
        if (contact.getLastName().isEmpty()) {
            errors.add("contactLastName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_last_name")));
        }
        if (contact.getCompanyId() == 0) {
            errors.add("emptyCompanyId", new ActionMessage("contactMgmt.contactEdit.error.emptyCompanyId"));
        }
        if (contact.getMessenger1Type() != 0 && contact.getMessenger1Id().isEmpty() || contact.getMessenger1Type() == 0 && !contact.getMessenger1Id().isEmpty() || contact.getMessenger2Type() != 0 && contact.getMessenger2Id().isEmpty() || contact.getMessenger2Type() == 0 && !contact.getMessenger2Id().isEmpty()) {
            errors.add("invalidMessengerInput", new ActionMessage("contactMgmt.contactEdit.error.invalidMessengerInput"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new CompanyContactDao(this.requestContext).addEmployeeContact(contact);
    }

    public ActionMessages updateEmployeeContact(Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contact.getFirstName().isEmpty()) {
            errors.add("contactFirstName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_first_name")));
        }
        if (contact.getLastName().isEmpty()) {
            errors.add("contactLastName", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.contact_last_name")));
        }
        if (contact.getMessenger1Type() != 0 && contact.getMessenger1Id().isEmpty() || contact.getMessenger1Type() == 0 && !contact.getMessenger1Id().isEmpty() || contact.getMessenger2Type() != 0 && contact.getMessenger2Id().isEmpty() || contact.getMessenger2Type() == 0 && !contact.getMessenger2Id().isEmpty()) {
            errors.add("invalidMessengerInput", new ActionMessage("contactMgmt.contactEdit.error.invalidMessengerInput"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        CompanyContactDao companyContactDao = new CompanyContactDao(this.requestContext);
        return companyContactDao.updateEmployeeContact(contact);
    }

    public ActionMessages addCompanyIssue(CompanyIssueLink issueMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(issueMap.createObjectMap());
    }

    public ActionMessages deleteCompanyIssue(CompanyIssueLink issueMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(issueMap.createObjectMap());
    }

    public List<Contact> getContacts(QueryCriteria query) throws DatabaseException {
        return new ContactDao(this.requestContext).getContacts(query);
    }

    public List<Contact> getLinkedContacts(QueryCriteria query, ObjectLink objectMap) throws DatabaseException {
        return new ContactDao(this.requestContext).getLinkedContacts(query, objectMap);
    }

    public int getContactCount(QueryCriteria query) throws DatabaseException {
        return new ContactDao(this.requestContext).getCount(query);
    }

    public Contact getContact(Integer contactId) throws DatabaseException, ObjectNotFoundException {
        return new ContactDao(this.requestContext).getContact(contactId);
    }

    public Contact getOptionalContact(Integer contactId) throws DatabaseException, ObjectNotFoundException {
        if (contactId == 0) {
            return new Contact();
        }
        return new ContactDao(this.requestContext).getContact(contactId);
    }

    public ActionMessages deleteContact(Contact contact) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contact.getId() == 0) {
            errors.add("emptyContactId", new ActionMessage("contactMgmt.contactEdit.error.emptyContactId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new ContactDao(this.requestContext).delete(contact);
    }
}

