/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.core;

import com.kwoksys.action.contacts.ContactSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;

public class CompanySearch
extends BaseSearch {
    public static final String COMPANY_TYPE_EQUALS = "companyTypeEquals";
    public static final String COMPANY_ID_EQUALS = "companyIdEquals";
    public static final String COMPANY_NAME_EQUALS = "companyNameEquals";
    public static final String CONTRACT_PROVIDERS = "contractProviders";

    public CompanySearch() {
    }

    public CompanySearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public void prepareMap(ContactSearchForm contactSearchForm) {
        String attrId = contactSearchForm.getAttrId();
        String attrValue = contactSearchForm.getAttrValue();
        String companyName = contactSearchForm.getCompanyName();
        String description = contactSearchForm.getDescription();
        String companyTag = contactSearchForm.getCompanyTag();
        if (!companyName.isEmpty()) {
            this.searchCriteriaMap.put("companyNameContains", companyName);
        }
        if (!description.isEmpty()) {
            this.searchCriteriaMap.put("companyDescription", description);
        }
        if (!companyTag.isEmpty()) {
            this.searchCriteriaMap.put("tagNameEquals", companyTag);
        }
        if (!attrId.isEmpty() && !attrValue.isEmpty()) {
            this.searchCriteriaMap.put("attrId", attrId);
            this.searchCriteriaMap.put("attrValue", attrValue);
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey("companyNameContains")) {
            query.appendWhereClause("lower(c.company_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("companyNameContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey(COMPANY_NAME_EQUALS)) {
            query.appendWhereClause("lower(c.company_name) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get(COMPANY_NAME_EQUALS)) + "')");
        }
        if (this.searchCriteriaMap.containsKey("companyDescription")) {
            query.appendWhereClause("lower(c.company_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("companyDescription")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("tagNameEquals")) {
            query.appendWhereClause("c.company_id in (select distinct ctmv.company_id from company_tag_map_view ctmv where lower(ctmv.tag_name) = lower('" + SqlUtils.encodeString(this.searchCriteriaMap.get("tagNameEquals")) + "'))");
        }
        if (this.searchCriteriaMap.containsKey("attrId") && this.searchCriteriaMap.containsKey("attrValue")) {
            query.appendWhereClause("c.company_id in (select object_id from object_attribute_value where attribute_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("attrId")) + " and lower(attr_value) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("attrValue")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey(COMPANY_TYPE_EQUALS)) {
            if (this.searchCriteriaMap.containsKey(COMPANY_ID_EQUALS)) {
                query.appendWhereClause("(c.company_id in (select object_id from object_attribute_value where attribute_id=" + Attributes.COMPANY_TYPES + " and attribute_field_id=" + SqlUtils.encodeInteger(this.searchCriteriaMap.get(COMPANY_TYPE_EQUALS)) + ") or c.company_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(COMPANY_ID_EQUALS)) + ")");
            } else {
                query.appendWhereClause("c.company_id in (select object_id from object_attribute_value where attribute_id=" + Attributes.COMPANY_TYPES + " and attribute_field_id=" + SqlUtils.encodeInteger(this.searchCriteriaMap.get(COMPANY_TYPE_EQUALS)) + ")");
            }
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_PROVIDERS)) {
            query.appendWhereClause("c.company_id in (select contract_provider from contract)");
        }
    }
}

