/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.core;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompanyUtils {
    public static final List<Integer> DEFAULT_COMPANY_TYPES = Arrays.asList(AttributeFieldIds.COMPANY_TYPE_HARDWARE_MANUFACTURER, AttributeFieldIds.COMPANY_TYPE_HARDWARE_VENDOR, AttributeFieldIds.COMPANY_TYPE_SOFTWARE_MAKER, AttributeFieldIds.COMPANY_TYPE_SOFTWARE_VENDOR);

    public static boolean isSortableColumn(String columnName) {
        return false;
    }

    public static List<DataRow> formatCompanyList(RequestContext requestContext, List<Company> companyDataset, Counter counter) throws DatabaseException {
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        if (companyDataset == null) {
            return list;
        }
        boolean hasCompanyDetailsAccess = Access.hasPermission(requestContext.getUser(), AppPaths.CONTACTS_COMPANY_DETAIL);
        List<String> columnHeaders = ConfigManager.app.getContactsCompanyColumnList();
        for (Company company : companyDataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnHeaders) {
                if (column.equals("company_id")) {
                    columns.add(String.valueOf(company.getId()));
                    continue;
                }
                if (column.equals("company_name")) {
                    Link link = new Link(requestContext);
                    link.setTitle(company.getName());
                    if (hasCompanyDetailsAccess) {
                        link.setAjaxPath(AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + company.getId());
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (!column.equals("rownum")) continue;
                columns.add(counter.incr() + ".");
            }
            DataRow dataRow = new DataRow();
            dataRow.setColumns(columns);
            list.add(dataRow);
        }
        return list;
    }

    public static List<Link> getCompanyTabs(RequestContext requestContext, Company company) throws DatabaseException {
        AccessUser user = requestContext.getUser();
        ArrayList<Link> tabList = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_DETAIL)) {
            tabList.add(new Link(requestContext).setName("mainContactTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + company.getId()).setTitle(Localizer.getText(requestContext, "contactMgmt.tab.companyMainContacts", new Object[]{company.getCountMainContact()})));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_CONTACT)) {
            tabList.add(new Link(requestContext).setName("otherContactTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTACT + "?companyId=" + company.getId()).setTitle(Localizer.getText(requestContext, "contactMgmt.tab.companyOtherContacts", new Object[]{company.getCountEmployeeContact()})));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_NOTE)) {
            tabList.add(new Link(requestContext).setName("noteTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_NOTE + "?companyId=" + company.getId()).setTitle(Localizer.getText(requestContext, "contactMgmt.tab.companyNotes", new Object[]{company.getCountNote()})));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_FILES)) {
            tabList.add(new Link(requestContext).setName("fileTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_FILES + "?companyId=" + company.getId()).setTitle(Localizer.getText(requestContext, "contactMgmt.tab.companyFiles", new Object[]{company.getCountFile()})));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_BOOKMARK)) {
            tabList.add(new Link(requestContext).setName("bookmarkTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_BOOKMARK + "?companyId=" + company.getId()).setTitle(Localizer.getText(requestContext, "contactMgmt.tab.companyBookmarks", new Object[]{company.getCountBookmark()})));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_ISSUES)) {
            tabList.add(new Link(requestContext).setName("issueTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_ISSUES + "?companyId=" + company.getId()).setTitleKey("contactMgmt.tab.companyIssues"));
        }
        if (Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_CONTRACTS)) {
            tabList.add(new Link(requestContext).setName("contractsTab").setAjaxPath(AppPaths.CONTACTS_COMPANY_CONTRACTS + "?companyId=" + company.getId()).setTitleKey("contracts"));
        }
        return tabList;
    }

    public static List<LabelValueBean> getCompanyOptions(RequestContext requestContext) throws DatabaseException {
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn("company_name");
        return CompanyUtils.getCompanyOptions(requestContext, query);
    }

    public static List<LabelValueBean> getCompanyOptions(RequestContext requestContext, QueryCriteria query) throws DatabaseException {
        ArrayList<LabelValueBean> companyIdOptions = new ArrayList<LabelValueBean>();
        ContactService contactService = ServiceProvider.getContactService(requestContext);
        for (Company company : contactService.getCompanies(query)) {
            companyIdOptions.add(new LabelValueBean(company.getName(), String.valueOf(company.getId())));
        }
        return companyIdOptions;
    }
}

