/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.core;

import com.kwoksys.action.contacts.ContactSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;

public class ContactSearch
extends BaseSearch {
    public static final String CONTACT_ID_EQUALS = "contactIdEquals";
    public static final String CONTACT_TYPE = "companyContactType";

    public void prepareMap(ContactSearchForm contactSearchForm) {
        String emailEquals;
        String titleEquals;
        String lastNameEquals;
        String firstNameEquals = contactSearchForm.getContactFirstName();
        if (!firstNameEquals.isEmpty()) {
            this.searchCriteriaMap.put("firstNameMatches", firstNameEquals);
        }
        if (!(lastNameEquals = contactSearchForm.getContactLastName()).isEmpty()) {
            this.searchCriteriaMap.put("lastNameMatches", lastNameEquals);
        }
        if (!(titleEquals = contactSearchForm.getContactTitle()).isEmpty()) {
            this.searchCriteriaMap.put("titleMatches", titleEquals);
        }
        if (!(emailEquals = contactSearchForm.getContactEmail()).isEmpty()) {
            this.searchCriteriaMap.put("emailMatches", emailEquals);
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(CONTACT_TYPE)) {
            query.appendWhereClause("c.company_contact_type = " + SqlUtils.encodeString(this.searchCriteriaMap.get(CONTACT_TYPE)) + "");
        }
        if (this.searchCriteriaMap.containsKey("firstNameMatches")) {
            query.appendWhereClause("lower(c.contact_first_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("firstNameMatches")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("lastNameMatches")) {
            query.appendWhereClause("lower(c.contact_last_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("lastNameMatches")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("titleMatches")) {
            query.appendWhereClause("lower(c.contact_title) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("titleMatches")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("emailMatches")) {
            query.appendWhereClause("(lower(c.contact_email_primary) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("emailMatches")) + "%') or lower(c.contact_email_secondary) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("emailMatches")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey(CONTACT_ID_EQUALS)) {
            query.appendWhereClause("c.contact_id=" + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTACT_ID_EQUALS)));
        }
    }
}

