/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.core;

import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ContactUtils {
    public static List<String> getSortableContactColumnList() {
        return Arrays.asList("contact_first_name", "contact_last_name", "contact_title", "company_name");
    }

    public static boolean isSortableColumn(String columnName) {
        return ContactUtils.getSortableContactColumnList().contains(columnName);
    }

    public static List<String> getContactColumnHeader() {
        return Arrays.asList(ConfigManager.app.getContactColumns());
    }

    public static List<String> getEmployeeContactColumnHeader() {
        return Arrays.asList("rownum", "contact_first_name", "contact_last_name", "contact_title", "contact_phone_work");
    }

    public static List<DataRow> formatContacts(RequestContext requestContext, List<Contact> contacts, List<String> columnHeaders, Counter counter) throws Exception {
        ArrayList<DataRow> dataList = new ArrayList<DataRow>();
        if (contacts.isEmpty()) {
            return dataList;
        }
        AccessUser user = requestContext.getUser();
        boolean canViewCompanyDetail = Access.hasPermission(user, AppPaths.CONTACTS_COMPANY_DETAIL);
        boolean canViewContactDetail = Access.hasPermission(user, AppPaths.CONTACTS_CONTACT_DETAIL);
        for (Contact contact : contacts) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnHeaders) {
                Link link;
                if (column.equals("contact_first_name")) {
                    link = new Link(requestContext);
                    link.setTitle(contact.getFirstName());
                    if (canViewContactDetail) {
                        link.setAjaxPath(AppPaths.CONTACTS_CONTACT_DETAIL + "?contactId=" + contact.getId());
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (column.equals("company_name")) {
                    link = new Link(requestContext);
                    link.setTitle(contact.getCompanyName());
                    if (canViewCompanyDetail) {
                        link.setAjaxPath(AppPaths.CONTACTS_COMPANY_DETAIL + "?companyId=" + contact.getCompanyId());
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (column.equals("contact_last_name")) {
                    columns.add(HtmlUtils.encode(contact.getLastName()));
                    continue;
                }
                if (column.equals("contact_title")) {
                    columns.add(HtmlUtils.encode(contact.getTitle()));
                    continue;
                }
                if (column.equals("contact_phone_work")) {
                    columns.add(HtmlUtils.encode(contact.getPhoneWork()));
                    continue;
                }
                if (column.equals("contact_email_primary")) {
                    columns.add(HtmlUtils.encode(contact.getEmailPrimary()));
                    continue;
                }
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (!column.equals("relationship_description")) continue;
                columns.add(HtmlUtils.encode(contact.getRelDescription()));
            }
            DataRow dataRow = new DataRow();
            dataRow.setRowId(String.valueOf(contact.getId()));
            dataRow.setColumns(columns);
            dataList.add(dataRow);
        }
        return dataList;
    }
}

