/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class CompanyContactDao
extends BaseDao {
    public CompanyContactDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Contact> getList(QueryCriteria query, Integer companyId, Integer companyContactType) throws DatabaseException {
        final ArrayList<Contact> contacts = new ArrayList<Contact>();
        QueryHelper queryHelper = new QueryHelper(){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Contact contact = new Contact();
                contact.setContactId(rs.getInt("contact_id"));
                contact.setCompanyId(rs.getInt("company_id"));
                contact.setCompanyName(StringUtils.replaceNull(rs.getString("company_name")));
                contact.setFirstName(StringUtils.replaceNull(rs.getString("contact_first_name")));
                contact.setLastName(StringUtils.replaceNull(rs.getString("contact_last_name")));
                contact.setDescription(StringUtils.replaceNull(rs.getString("contact_description")));
                contact.setTitle(StringUtils.replaceNull(rs.getString("contact_title")));
                contact.setPhoneHome(StringUtils.replaceNull(rs.getString("contact_phone_home")));
                contact.setPhoneMobile(StringUtils.replaceNull(rs.getString("contact_phone_mobile")));
                contact.setPhoneWork(StringUtils.replaceNull(rs.getString("contact_phone_work")));
                contact.setFax(StringUtils.replaceNull(rs.getString("contact_fax")));
                contact.setEmailPrimary(StringUtils.replaceNull(rs.getString("contact_email_primary")));
                contact.setEmailSecondary(StringUtils.replaceNull(rs.getString("contact_email_secondary")));
                contact.setHomepageUrl(StringUtils.replaceNull(rs.getString("contact_homepage_url")));
                contact.setAddressStreetPrimary(StringUtils.replaceNull(rs.getString("address_street_primary")));
                contact.setAddressCityPrimary(StringUtils.replaceNull(rs.getString("address_city_primary")));
                contact.setAddressStatePrimary(StringUtils.replaceNull(rs.getString("address_state_primary")));
                contact.setAddressZipcodePrimary(StringUtils.replaceNull(rs.getString("address_zipcode_primary")));
                contact.setAddressCountryPrimary(StringUtils.replaceNull(rs.getString("address_country_primary")));
                contacts.add(contact);
            }
        };
        if (companyId == null) {
            queryHelper.setSqlStatement(ContactQueries.selectContactsReportQuery(query));
            queryHelper.addInputInt(companyContactType);
        } else {
            queryHelper.setSqlStatement(ContactQueries.selectExpandedContactListQuery(query));
            queryHelper.addInputInt(companyId);
            queryHelper.addInputInt(companyContactType);
        }
        this.executeQuery(queryHelper);
        return contacts;
    }

    public ActionMessages addCompanyContact(Contact contact) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.insertContactQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(ObjectTypes.COMPANY_MAIN_CONTACT);
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull(contact.getTitle());
        queryHelper.addInputInt(contact.getCompanyId());
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull(contact.getPhoneWork());
        queryHelper.addInputStringConvertNull(contact.getFax());
        queryHelper.addInputStringConvertNull(contact.getEmailPrimary());
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputInt(0);
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputInt(0);
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull(contact.getHomepageUrl());
        queryHelper.addInputStringConvertNull(contact.getDescription());
        queryHelper.addInputStringConvertNull(contact.getAddressStreetPrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressCityPrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressStatePrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressZipcodePrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressCountryPrimary());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            contact.setContactId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages addEmployeeContact(Contact contact) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.insertContactQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
        queryHelper.addInputStringConvertNull(contact.getFirstName());
        queryHelper.addInputStringConvertNull(contact.getLastName());
        queryHelper.addInputStringConvertNull(contact.getTitle());
        queryHelper.addInputInt(contact.getCompanyId());
        queryHelper.addInputStringConvertNull(contact.getPhoneHome());
        queryHelper.addInputStringConvertNull(contact.getPhoneMobile());
        queryHelper.addInputStringConvertNull(contact.getPhoneWork());
        queryHelper.addInputStringConvertNull(contact.getFax());
        queryHelper.addInputStringConvertNull(contact.getEmailPrimary());
        queryHelper.addInputStringConvertNull(contact.getEmailSecondary());
        queryHelper.addInputInt(contact.getMessenger1Type());
        queryHelper.addInputStringConvertNull(contact.getMessenger1Id());
        queryHelper.addInputInt(contact.getMessenger2Type());
        queryHelper.addInputStringConvertNull(contact.getMessenger2Id());
        queryHelper.addInputStringConvertNull(contact.getHomepageUrl());
        queryHelper.addInputStringConvertNull(contact.getDescription());
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            contact.setContactId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages updateCompanyContact(Contact contact) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.updateContactQuery());
        queryHelper.addInputInt(contact.getId());
        queryHelper.addInputInt(contact.getCompanyId());
        queryHelper.addInputInt(ObjectTypes.COMPANY_MAIN_CONTACT);
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(contact.getTitle());
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(contact.getPhoneWork());
        queryHelper.addInputStringConvertNull(contact.getFax());
        queryHelper.addInputStringConvertNull(contact.getEmailPrimary());
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputInt(0);
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputInt(0);
        queryHelper.addInputStringConvertNull(null);
        queryHelper.addInputStringConvertNull(contact.getHomepageUrl());
        queryHelper.addInputStringConvertNull(contact.getDescription());
        queryHelper.addInputStringConvertNull(contact.getAddressStreetPrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressCityPrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressStatePrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressZipcodePrimary());
        queryHelper.addInputStringConvertNull(contact.getAddressCountryPrimary());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages updateEmployeeContact(Contact contact) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.updateContactQuery());
        queryHelper.addInputInt(contact.getId());
        queryHelper.addInputInt(contact.getCompanyId());
        queryHelper.addInputInt(ObjectTypes.COMPANY_EMPLOYEE_CONTACT);
        queryHelper.addInputStringConvertNull(contact.getFirstName());
        queryHelper.addInputStringConvertNull(contact.getLastName());
        queryHelper.addInputStringConvertNull(contact.getTitle());
        queryHelper.addInputStringConvertNull(contact.getPhoneHome());
        queryHelper.addInputStringConvertNull(contact.getPhoneMobile());
        queryHelper.addInputStringConvertNull(contact.getPhoneWork());
        queryHelper.addInputStringConvertNull(contact.getFax());
        queryHelper.addInputStringConvertNull(contact.getEmailPrimary());
        queryHelper.addInputStringConvertNull(contact.getEmailSecondary());
        queryHelper.addInputInt(contact.getMessenger1Type());
        queryHelper.addInputStringConvertNull(contact.getMessenger1Id());
        queryHelper.addInputInt(contact.getMessenger2Type());
        queryHelper.addInputStringConvertNull(contact.getMessenger2Id());
        queryHelper.addInputStringConvertNull(contact.getHomepageUrl());
        queryHelper.addInputStringConvertNull(contact.getDescription());
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputStringConvertNull("");
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }
}

