/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.dao;

import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dao.AttributeDao;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.contacts.dto.CompanyTag;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompanyDao
extends BaseDao {
    public CompanyDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<Company> getCompanies(QueryCriteria queryCriteria, ObjectLink objectMap) throws DatabaseException {
        final ArrayList<Company> companies = new ArrayList<Company>();
        QueryHelper queryHelper = new QueryHelper(){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Company company = new Company();
                company.setId(rs.getInt("company_id"));
                company.setName(rs.getString("company_name"));
                company.setDescription(StringUtils.replaceNull(rs.getString("company_description")));
                companies.add(company);
            }
        };
        if (objectMap != null) {
            if (objectMap.getLinkedObjectId() == 0) {
                queryHelper.setSqlStatement(ContactQueries.selectLinkedCompanyListQuery(queryCriteria));
                queryHelper.addInputInt(objectMap.getObjectId());
                queryHelper.addInputInt(objectMap.getObjectTypeId());
                queryHelper.addInputInt(objectMap.getLinkedObjectTypeId());
            } else {
                queryHelper.setSqlStatement(ContactQueries.selectObjectCompanyListQuery(queryCriteria));
                queryHelper.addInputInt(objectMap.getLinkedObjectId());
                queryHelper.addInputInt(objectMap.getLinkedObjectTypeId());
                queryHelper.addInputInt(objectMap.getObjectTypeId());
            }
        } else {
            queryHelper.setSqlStatement(ContactQueries.selectCompanyListQuery(queryCriteria));
        }
        this.executeQuery(queryHelper);
        return companies;
    }

    public int getCount(QueryCriteria query) throws DatabaseException {
        return this.getRowCount(ContactQueries.getCompanyCountQuery(query));
    }

    public Company getCompany(Integer companyId) throws DatabaseException, ObjectNotFoundException {
        final ArrayList companies = new ArrayList();
        QueryHelper queryHelper = new QueryHelper(ContactQueries.selectCompanyDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                Company company = new Company();
                company.setId(rs.getInt("company_id"));
                company.setName(StringUtils.replaceNull(rs.getString("company_name")));
                company.setDescription(StringUtils.replaceNull(rs.getString("company_description")));
                company.setTags("");
                company.setCountMainContact(rs.getInt("main_contact_count"));
                company.setCountEmployeeContact(rs.getInt("employee_contact_count"));
                company.setCountFile(rs.getInt("file_count"));
                company.setCountBookmark(rs.getInt("bookmark_count"));
                company.setCountNote(rs.getInt("note_count"));
                company.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                company.setModificationDate(DatetimeUtils.getDate(rs, "modification_date"));
                company.setCreator(new AccessUser());
                company.getCreator().setId(rs.getInt("creator"));
                company.getCreator().setUsername(rs.getString("creator_username"));
                company.getCreator().setDisplayName(rs.getString("creator_display_name"));
                company.setModifier(new AccessUser());
                company.getModifier().setId(rs.getInt("modifier"));
                company.getModifier().setUsername(rs.getString("modifier_username"));
                company.getModifier().setDisplayName(rs.getString("modifier_display_name"));
                companies.add(company);
            }
        };
        queryHelper.addInputInt(companyId);
        this.executeSingleRecordQuery(queryHelper);
        if (!companies.isEmpty()) {
            return (Company)companies.get(0);
        }
        throw new ObjectNotFoundException("Company ID: " + companyId);
    }

    public List<Company> getLinkedCompanies(QueryCriteria query, ObjectLink objectMap) throws DatabaseException {
        return this.getCompanies(query, objectMap);
    }

    public List<Map<String, String>> getTagList(QueryCriteria query, Integer companyId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.selectCompanyTagsQuery(query));
        queryHelper.addInputInt(companyId);
        return this.executeQueryReturnList(queryHelper);
    }

    public List<Integer> getCompanyTypes(QueryCriteria query) throws DatabaseException {
        final ArrayList<Integer> list = new ArrayList<Integer>();
        QueryHelper queryHelper = new QueryHelper(AdminQueries.selectAttributeValuesQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                list.add(rs.getInt("attribute_field_id"));
            }
        };
        this.executeQuery(queryHelper);
        return list;
    }

    public List<Map<String, String>> getExistingTagList(QueryCriteria query) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.selectCompanyExistingTagsQuery(query));
        return this.executeQueryReturnList(queryHelper);
    }

    public ActionMessages resetFileCount(Integer companyId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.updateCompanyFileCountQuery());
        queryHelper.addInputInt(ObjectTypes.COMPANY);
        queryHelper.addInputInt(companyId);
        return this.executeProcedure(queryHelper);
    }

    private Integer addCompanyTag(Connection conn, CompanyTag companyTag) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.insertCompanyTagQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputInt(companyTag.getCompanyId());
        queryHelper.addInputStringConvertNull(companyTag.getName());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        queryHelper.executeProcedure(conn);
        return (Integer)queryHelper.getSqlOutputs().get(0);
    }

    public void deleteCompanyTag(Connection conn, Integer companyId, String tagName) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.deleteCompanyTagQuery());
        queryHelper.addInputInt(companyId);
        queryHelper.addInputStringConvertNull(tagName);
        queryHelper.executeProcedure(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages add(Company company) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(ContactQueries.insertCompanyQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(company.getName());
        queryHelper.addInputStringConvertNull(company.getDescription());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            String[] companyTags;
            queryHelper.executeProcedure(conn);
            company.setId((Integer)queryHelper.getSqlOutputs().get(0));
            if (!company.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, company.getId(), company.getCustomValues());
            }
            if (company.getTypeIds() != null) {
                for (Integer companyType : company.getTypeIds()) {
                    queryHelper = new QueryHelper(AdminQueries.addAttributeValueQuery());
                    queryHelper.addInputInt(company.getId());
                    queryHelper.addInputInt(Attributes.COMPANY_TYPES);
                    queryHelper.addInputInt(companyType);
                    queryHelper.addInputStringConvertNull("");
                    queryHelper.executeProcedure(conn);
                }
            }
            for (String tag : companyTags = company.getCompanyTagsCommaSeparated()) {
                if (tag.trim().isEmpty()) continue;
                CompanyTag companyTag = new CompanyTag();
                companyTag.setName(tag.trim());
                companyTag.setCompanyId(company.getId());
                this.addCompanyTag(conn, companyTag);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionMessages update(Company company) throws DatabaseException {
        Connection conn = this.getConnection();
        QueryHelper queryHelper = new QueryHelper(ContactQueries.updateCompanyQuery());
        queryHelper.addInputInt(company.getId());
        queryHelper.addInputStringConvertNull(company.getName());
        queryHelper.addInputStringConvertNull(company.getDescription());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        try {
            String[] stringArray;
            queryHelper.executeProcedure(conn);
            if (!company.getCustomValues().isEmpty()) {
                AttributeDao attributeDao = new AttributeDao(this.requestContext);
                attributeDao.updateAttributeValue(conn, company.getId(), company.getCustomValues());
            }
            QueryHelper typesQueryHelper = new QueryHelper(AdminQueries.updateAttributeValueQuery());
            typesQueryHelper.addInputInt(company.getId());
            typesQueryHelper.addInputInt(Attributes.COMPANY_TYPES);
            typesQueryHelper.addInputStringConvertNull(null);
            typesQueryHelper.executeProcedure(conn);
            if (company.getTypeIds() != null) {
                for (Integer n : company.getTypeIds()) {
                    typesQueryHelper = new QueryHelper(AdminQueries.addAttributeValueQuery());
                    typesQueryHelper.addInputInt(company.getId());
                    typesQueryHelper.addInputInt(Attributes.COMPANY_TYPES);
                    typesQueryHelper.addInputInt(n);
                    typesQueryHelper.addInputStringConvertNull("");
                    typesQueryHelper.executeProcedure(conn);
                }
            }
            ArrayList<String> oldTags = new ArrayList<String>();
            for (Map<String, String> map : this.getTagList(new QueryCriteria(), company.getId())) {
                oldTags.add(map.get("tag_name").toString());
            }
            for (String tag : stringArray = company.getCompanyTagsCommaSeparated()) {
                if ((tag = tag.trim()).isEmpty()) continue;
                if (oldTags.contains(tag)) {
                    oldTags.remove(tag);
                    continue;
                }
                CompanyTag companyTag = new CompanyTag();
                companyTag.setName(tag.trim());
                companyTag.setCompanyId(company.getId());
                this.addCompanyTag(conn, companyTag);
            }
            for (String oldTag : oldTags) {
                this.deleteCompanyTag(conn, company.getId(), oldTag);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
        finally {
            this.closeConnection(conn);
        }
        return this.errors;
    }

    public ActionMessages delete(Company company) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.deleteCompanyQuery());
        queryHelper.addInputInt(ObjectTypes.COMPANY);
        queryHelper.addInputInt(ObjectTypes.CONTACT);
        queryHelper.addInputInt(company.getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages resetNoteCount(Integer companyId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.updateCompanyNoteCountQuery());
        queryHelper.addInputInt(companyId);
        return this.executeProcedure(queryHelper);
    }
}

