/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.CompanyNote;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class CompanyNoteDao
extends BaseDao {
    public CompanyNoteDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<CompanyNote> getNoteList(QueryCriteria query, final Integer companyId) throws DatabaseException {
        final ArrayList<CompanyNote> companyNotes = new ArrayList<CompanyNote>();
        QueryHelper queryHelper = new QueryHelper(ContactQueries.selectCompanyNoteQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                CompanyNote companyNote = new CompanyNote(companyId);
                companyNote.setNoteId(rs.getInt("note_id"));
                companyNote.setNoteName(StringUtils.replaceNull(rs.getString("note_name")));
                companyNote.setNoteDescription(StringUtils.replaceNull(rs.getString("note_description")));
                companyNote.setNoteTypeId(rs.getInt("note_type"));
                companyNote.setCompanyId(rs.getInt("company_id"));
                companyNote.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                companyNotes.add(companyNote);
            }
        };
        queryHelper.addInputInt(companyId);
        this.executeQuery(queryHelper);
        return companyNotes;
    }

    public ActionMessages addNote(CompanyNote note) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(ContactQueries.insertCompanyNoteQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(note.getNoteName());
        queryHelper.addInputStringConvertNull(note.getNoteDescription());
        queryHelper.addInputInt(note.getNoteTypeId());
        queryHelper.addInputInt(note.getCompanyId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            note.setNoteId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }
}

