/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.dao;

import com.kwoksys.framework.connections.database.QueryCriteria;

public class ContactQueries {
    public static String getOrderByColumn(String column) {
        if (column.equals("company_name")) {
            return "lower(company_name)";
        }
        if (column.equals("contact_first_name")) {
            return "lower(contact_first_name)";
        }
        if (column.equals("contact_last_name")) {
            return "lower(contact_last_name)";
        }
        if (column.equals("contact_title")) {
            return "lower(contact_title)";
        }
        if (column.equals("tag_name")) {
            return "lower(tag_name)";
        }
        return column;
    }

    public static String selectCompanyListQuery(QueryCriteria query) {
        return "select c.company_id, c.company_name, c.company_description from company c " + query.createWhereClause();
    }

    public static String selectLinkedCompanyListQuery(QueryCriteria query) {
        return ContactQueries.selectCompanyListQuery(new QueryCriteria()) + "where c.company_id in (select om.linked_object_id from object_map om where om.object_id=? and om.object_type_id=? and om.linked_object_type_id=?) " + query.createWhereClause();
    }

    public static String selectObjectCompanyListQuery(QueryCriteria query) {
        return ContactQueries.selectCompanyListQuery(new QueryCriteria()) + "where c.company_id in (select om.object_id from object_map om where om.linked_object_id=? and om.linked_object_type_id=? and om.object_type_id=?) " + query.createAndClause();
    }

    public static String getCompanyCountQuery(QueryCriteria query) {
        return "select count(c.company_id) as row_count from company c " + query.createWhereCountClause();
    }

    public static String selectCompanyDetailQuery() {
        return "select company_id, company_name, company_description, main_contact_count, employee_contact_count, file_count, bookmark_count, note_count, creator, creation_date, creator_username, creator_display_name, modifier, modification_date, modifier_username, modifier_display_name from company_view where company_id = ? ";
    }

    public static String selectCompanyTagsQuery(QueryCriteria query) {
        return "select ctmv.tag_id, ctmv.tag_name from company_tag_map_view ctmv where ctmv.company_id = ? " + query.createAndClause();
    }

    public static String selectCompanyExistingTagsQuery(QueryCriteria query) {
        return "select ct.tag_id, ct.tag_name, ct.creation_date from company_tag ct " + query.createWhereClause();
    }

    public static String selectCompanyNoteQuery(QueryCriteria query) {
        return "select cn.note_id, cn.note_name, cn.note_description, cn.note_type, cn.company_id, cn.creator, cn.creation_date from company_note cn where cn.company_id = ? " + query.createAndClause();
    }

    public static String selectExpandedContactListQuery(QueryCriteria query) {
        return ContactQueries.selectExpandedContactsQuery() + "where cc.company_id=? and cc.company_contact_type=? " + query.createAndClause();
    }

    public static String selectContactsReportQuery(QueryCriteria query) {
        return ContactQueries.selectExpandedContactsQuery() + "where cc.company_contact_type=? " + query.createAndClause();
    }

    public static String selectExpandedContactsQuery() {
        return "select cc.contact_id, cc.contact_first_name, cc.contact_last_name, cc.contact_title, cc.contact_phone_home, cc.contact_phone_mobile, cc.contact_phone_work, cc.contact_description, cc.contact_fax, cc.contact_email_primary, cc.contact_email_secondary, cc.contact_homepage_url, c.company_name, c.company_id, cc.address_street_primary, cc.address_city_primary, cc.address_state_primary, cc.address_zipcode_primary, cc.address_country_primary from contact cc left outer join company c on cc.company_id = c.company_id ";
    }

    public static String selectContactListQuery(QueryCriteria query) {
        return "select c.contact_id, c.contact_first_name, c.contact_last_name, c.contact_title, c.contact_email_primary, c.company_id, c.company_name from contact_view c " + query.createWhereClause();
    }

    public static String selectLinkedContactsQuery(QueryCriteria query) {
        return "select c.contact_id, c.contact_first_name, c.contact_last_name, c.contact_title, c.contact_email_primary, c.company_id, c.company_name, om.relationship_name from contact_view c join object_map om on c.contact_id=om.linked_object_id and om.object_id=? and om.object_type_id=? and om.linked_object_type_id=? " + query.createWhereClause();
    }

    public static String getContactCountQuery(QueryCriteria query) {
        return "select count(c.contact_id) as row_count  from contact c " + query.createWhereCountClause();
    }

    public static String selectContactDetailQuery() {
        return "select c.contact_id, c.contact_first_name, c.contact_last_name, c.contact_title, c.contact_phone_home, c.contact_phone_mobile, c.contact_phone_work, c.contact_description, c.contact_fax, c.contact_email_primary, c.contact_email_secondary, c.contact_homepage_url, c.company_name, c.company_id, c.address_street_primary, c.address_city_primary, c.address_state_primary, c.address_zipcode_primary, c.address_country_primary, c.messenger_1_type, c.messenger_1_id, c.messenger_2_type, c.messenger_2_id, c.user_id, c.creator, c.creation_date, c.creator_username, c.creator_display_name, c.modifier, c.modification_date, c.modifier_username, c.modifier_display_name from contact_view c where c.contact_id = ? ";
    }

    public static String insertCompanyQuery() {
        return "{call sp_company_add(?,?,?,?)}";
    }

    public static String updateCompanyQuery() {
        return "{call sp_company_update(?,?,?,?)}";
    }

    public static String deleteCompanyQuery() {
        return "{call sp_company_delete(?,?,?)}";
    }

    public static String updateCompanyNoteCountQuery() {
        return "{call sp_company_count_note_update(?)}";
    }

    public static String updateCompanyFileCountQuery() {
        return "{call sp_company_count_file_update(?,?)}";
    }

    public static String updateCompanyBookmarkCountQuery() {
        return "{call sp_company_count_bookmark_update(?,?)}";
    }

    public static String insertCompanyNoteQuery() {
        return "{call sp_company_note_add(?,?,?,?,?,?)}";
    }

    public static String insertCompanyTagQuery() {
        return "{call sp_company_tag_add(?,?,?,?)}";
    }

    public static String deleteCompanyTagQuery() {
        return "{call sp_company_tag_delete(?,?)}";
    }

    public static String insertContactQuery() {
        return "{call sp_contact_add(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String updateContactQuery() {
        return "{call sp_contact_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
    }

    public static String deleteContactQuery() {
        return "{call sp_contact_delete(?,?,?,?)}";
    }
}

