/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contacts.dto;

import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.ObjectTypes;
import java.util.Arrays;
import java.util.List;

public class Company
extends BaseObject {
    public static final String COMPANY_ID = "company_id";
    public static final String COMPANY_NAME = "company_name";
    public static final String DESCRIPTION = "company_description";
    public static final String TYPES = "company_types";
    private Integer id;
    private String name;
    private String description;
    private String tags = "";
    private int countMainContact = 0;
    private int countEmployeeContact = 0;
    private int countFile = 0;
    private int countBookmark = 0;
    private int countNote = 0;
    private Integer fileId = 0;
    private Integer contactType;
    private Integer tagId;
    private List<Integer> typeIds;

    public static List<String> getSortableCompanyColumnList() {
        return Arrays.asList(COMPANY_NAME);
    }

    public static boolean isSortableCompanyColumn(String columnName) {
        return Company.getSortableCompanyColumnList().contains(columnName);
    }

    public Company() {
        super(ObjectTypes.COMPANY);
    }

    public boolean isValidTagFormat() {
        return !this.tags.contains(";");
    }

    public int numTagsAllowed() {
        return 50;
    }

    @Override
    public boolean isAttrEmpty(String attrName) {
        if (attrName.equals(TYPES)) {
            return this.typeIds.isEmpty();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public void setContactType(Integer contactType) {
        this.contactType = contactType;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String[] getCompanyTagsCommaSeparated() {
        return this.tags.split(",");
    }

    public int getCountMainContact() {
        return this.countMainContact;
    }

    public int getCountEmployeeContact() {
        return this.countEmployeeContact;
    }

    public int getCountFile() {
        return this.countFile;
    }

    public int getCountBookmark() {
        return this.countBookmark;
    }

    public int getCountNote() {
        return this.countNote;
    }

    public Integer getContactType() {
        return this.contactType;
    }

    public Integer getTagId() {
        return this.tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public void setCountMainContact(int countMainContact) {
        this.countMainContact = countMainContact;
    }

    public void setCountEmployeeContact(int countEmployeeContact) {
        this.countEmployeeContact = countEmployeeContact;
    }

    public void setCountFile(int countFile) {
        this.countFile = countFile;
    }

    public void setCountBookmark(int countBookmark) {
        this.countBookmark = countBookmark;
    }

    public void setCountNote(int countNote) {
        this.countNote = countNote;
    }

    public List<Integer> getTypeIds() {
        return this.typeIds;
    }

    public void setTypeIds(List<Integer> typeIds) {
        this.typeIds = typeIds;
    }
}

