/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contracts;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dao.ContractDao;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.biz.system.dto.linking.ContractContactLink;
import com.kwoksys.biz.system.dto.linking.ContractHardwareLink;
import com.kwoksys.biz.system.dto.linking.ContractSoftwareLink;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.mail.EmailMessage;
import com.kwoksys.framework.connections.mail.SmtpService;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContractService {
    private static final Logger LOGGER = Logger.getLogger(ContractService.class.getName());
    private RequestContext requestContext;

    public ContractService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void fetchContracts(QueryCriteria queryCriteria) throws DatabaseException {
        new ContractDao(this.requestContext).fetchContracts(queryCriteria);
    }

    public void fetchLinkedContracts(QueryCriteria queryCriteria, ObjectLink objectMap) throws DatabaseException {
        new ContractDao(this.requestContext).fetchContracts(queryCriteria, objectMap);
    }

    public int getContractCount(QueryCriteria queryCriteria) throws DatabaseException {
        return new ContractDao(this.requestContext).getContractCount(queryCriteria);
    }

    public Contract getContract(Integer contractId) throws DatabaseException, ObjectNotFoundException {
        return new ContractDao(this.requestContext).getContract(contractId);
    }

    public List<Hardware> getContractHardwareList(QueryCriteria query, Integer contractId) throws DatabaseException {
        ContractHardwareLink contractHardware = new ContractHardwareLink(contractId);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        return hardwareService.getLinkedHardwareList(query, contractHardware.createObjectMap());
    }

    public List<Software> getContractSoftwareList(QueryCriteria query, Integer contractId) throws DatabaseException {
        ContractSoftwareLink contractSoftware = new ContractSoftwareLink(contractId);
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        return softwareService.getLinkedSoftwareList(query, contractSoftware.createObjectMap());
    }

    public Map<String, String> getContractsSummary() throws DatabaseException {
        ContractDao contractDao = new ContractDao(this.requestContext);
        return contractDao.getContractsSummary();
    }

    public ActionMessages addContract(Contract contract, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("contractName").setTitleKey("common.column.contract_name").calculateLength(contract.getName()).setColumnName("contract.contract_name").setNullable(false));
        if (contract.hasContractEffectiveDate() && !contract.isValidContractEffectiveDate()) {
            errors.add("invalidEffectiveDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_effective_date")));
        }
        if (contract.hasContractExpirationDate() && !contract.isValidContractExpirationDate()) {
            errors.add("invalidExpirationDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_expiration_date")));
        }
        if (contract.hasContractRenewalDate() && !contract.isValidContractRenewalDate()) {
            errors.add("invalidRenewalDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_renewal_date")));
        }
        validator.validateAttrs(contract, contract.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        ContractDao contractDao = new ContractDao(this.requestContext);
        return contractDao.addContract(contract);
    }

    public ActionMessages updateContract(Contract contract, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("contractName").setTitleKey("common.column.contract_name").calculateLength(contract.getName()).setColumnName("contract.contract_name").setNullable(false));
        if (contract.hasContractEffectiveDate() && !contract.isValidContractEffectiveDate()) {
            errors.add("invalidEffectiveDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_effective_date")));
        }
        if (contract.hasContractExpirationDate() && !contract.isValidContractExpirationDate()) {
            errors.add("invalidExpirationDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_expiration_date")));
        }
        if (contract.hasContractRenewalDate() && !contract.isValidContractRenewalDate()) {
            errors.add("invalidRenewalDate", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.contract_renewal_date")));
        }
        validator.validateAttrs(contract, contract.getType(), customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        ContractDao contractDao = new ContractDao(this.requestContext);
        return contractDao.updateContract(contract);
    }

    public ActionMessages deleteContract(Integer contractId) throws DatabaseException {
        List<File> deleteFileList = this.getContractFiles(new QueryCriteria(), contractId);
        ContractDao contractDao = new ContractDao(this.requestContext);
        ActionMessages errors = contractDao.delete(contractId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getContractFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public ActionMessages addContractHardware(ContractHardwareLink contractHardware) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contractHardware.getHardwareId() == 0) {
            errors.add("emptyHardwareId", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.hardware_id")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(contractHardware.createObjectMap());
    }

    public ActionMessages deleteContractHardware(ContractHardwareLink contractHardware) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(contractHardware.createObjectMap());
    }

    public ActionMessages addContractSoftware(ContractSoftwareLink contractSoftware) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (contractSoftware.getSoftwareId() == 0) {
            errors.add("emptySoftwareId", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.software_id")));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(contractSoftware.createObjectMap());
    }

    public ActionMessages deleteContractSoftware(ContractSoftwareLink contractSoftware) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(contractSoftware.createObjectMap());
    }

    public List<File> getContractFiles(QueryCriteria query, Integer contractId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(query, ObjectTypes.CONTRACT, contractId);
    }

    public File getContractFile(Integer contractId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.CONTRACT, contractId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getContractFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getContractUploadedFilePrefix());
        return file;
    }

    public List<Contact> getContractContacts(QueryCriteria query, Integer contractId) throws DatabaseException {
        ContractContactLink link = new ContractContactLink();
        link.setContractId(contractId);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        return contactService.getLinkedContacts(query, link.createObjectMap());
    }

    public ActionMessages addContractContact(ContractContactLink contactLink) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(contactLink.createObjectMap());
    }

    public ActionMessages deleteContractContact(ContractContactLink contactLink) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(contactLink.createObjectMap());
    }

    public void sendContractExpirationReminder(Contract contract, int nextThreshold) throws DatabaseException {
        AccessUser contractOwner = new CacheManager(this.requestContext).getUserCache(contract.getOwnerId());
        boolean hasPermission = false;
        if (contractOwner == null) {
            LOGGER.warning(LogConfigManager.SCHEDULER_PREFIX + " Contract owner ID " + contract.getOwnerId() + " was not found. Skipping notification.");
        } else {
            hasPermission = contractOwner.hasPermission(12);
            if (!hasPermission) {
                LOGGER.warning(LogConfigManager.SCHEDULER_PREFIX + " Contract owner " + contractOwner.getDisplayName() + " has no permission to contract " + contract.getName() + ". Skipping notification.");
            } else {
                try {
                    EmailMessage message = new EmailMessage();
                    message.getToField().add(contractOwner.getEmail());
                    message.setFromField(ConfigManager.email.getSmtpFrom());
                    String contractExpirationDate = ContractUtils.formatExpirationDateText(this.requestContext, this.requestContext.getSysdate(), contract.getExpireDate());
                    String subject = Localizer.getText(this.requestContext, "contracts.expirationNotification.subject", (Object[])new String[]{contract.getName()});
                    message.setSubjectField(subject);
                    String body = ConfigManager.email.getContractExpireNotificationEmailTemplate().isEmpty() ? Localizer.getText(this.requestContext, "contracts.expirationNotification.body", (Object[])new String[]{String.valueOf(contract.getId()), contract.getName(), contractExpirationDate}) : ConfigManager.email.getContractExpireNotificationEmailTemplate();
                    AttributeManager attributeManager = new AttributeManager(this.requestContext);
                    body = body.replace("%CONTRACT_NAME%", contract.getName()).replace("%CONTRACT_EXPIRATION%", contractExpirationDate).replace("%CONTRACT_DESCRIPTION%", contract.getDescription()).replace("%CONTRACT_TYPE%", attributeManager.getAttrFieldNameCache(Attributes.CONTRACT_TYPE, contract.getType())).replace("%CONTRACT_URL%", ConfigManager.system.getAppUrl() + AppPaths.ROOT + AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
                    message.setBodyField(body);
                    new SmtpService().send(message);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Problem sending contract expiration notification", e);
                }
            }
        }
        ContractDao contractDao = new ContractDao(this.requestContext);
        contractDao.updateContractNotification(contract, nextThreshold);
    }
}

