/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contracts.core;

import com.kwoksys.action.contracts.ContractSearchForm;
import com.kwoksys.biz.base.BaseSearch;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.SqlUtils;
import com.kwoksys.framework.http.RequestContext;

public class ContractSearch
extends BaseSearch {
    public static final String CONTRACT_PROVIDER_ID_KEY = "contractProviderId";
    public static final String CONTRACT_STAGE_KEY = "stage";
    public static final String CONTRACT_EXPIRE_BEFORE_KEY = "contractExpireBefore";
    public static final String CONTRACT_EXPIRE_AFTER_KEY = "contractExpireAfter";
    public static final String CONTRACT_NON_EXPIRED_KEY = "nonExpiredContracts";
    public static final String CONTRACT_EXPIRED_KEY = "expiredContracts";
    public static final String CONTRACT_EXPIRED_NOTIFIED_KEY = "expirationNotified";

    public ContractSearch(RequestContext requestContext, String sessionKey) {
        super(requestContext, sessionKey);
    }

    public ContractSearch() {
    }

    public void prepareMap(ContractSearchForm contractSearchForm) {
        String cmd = this.requestContext.getParameterString("cmd");
        if (!cmd.isEmpty()) {
            this.reset();
            if (cmd.equals("filter")) {
                String stageFilter = this.requestContext.getParameterString("stageFilter");
                contractSearchForm.setStageFilter(stageFilter);
                if (!stageFilter.isEmpty() && !stageFilter.equals("0")) {
                    this.searchCriteriaMap.put(CONTRACT_STAGE_KEY, stageFilter);
                }
            } else {
                contractSearchForm.setRequest(this.requestContext);
                if (cmd.equals("groupBy")) {
                    String contractExpire = this.requestContext.getParameterString("contractExpire");
                    if (!contractExpire.isEmpty()) {
                        String[] interval = contractExpire.split("_");
                        if (interval.length == 1) {
                            this.searchCriteriaMap.put(CONTRACT_EXPIRE_BEFORE_KEY, interval[0]);
                        } else {
                            this.searchCriteriaMap.put(CONTRACT_EXPIRE_AFTER_KEY, interval[0]);
                            this.searchCriteriaMap.put(CONTRACT_EXPIRE_BEFORE_KEY, interval[1]);
                        }
                    }
                } else if (cmd.equals("showNonExpired")) {
                    this.searchCriteriaMap.put(CONTRACT_NON_EXPIRED_KEY, true);
                } else if (cmd.equals("search")) {
                    if (!contractSearchForm.getContractName().isEmpty()) {
                        this.searchCriteriaMap.put("contractNameContains", contractSearchForm.getContractName());
                    }
                    if (!contractSearchForm.getDescription().isEmpty()) {
                        this.searchCriteriaMap.put("description", contractSearchForm.getDescription());
                    }
                    if (contractSearchForm.getContractTypeId() != 0) {
                        this.searchCriteriaMap.put("contractTypeId", contractSearchForm.getContractTypeId());
                    }
                    if (contractSearchForm.getContractProviderId() != 0) {
                        this.searchCriteriaMap.put(CONTRACT_PROVIDER_ID_KEY, contractSearchForm.getContractProviderId());
                    }
                    if (contractSearchForm.getStage() != 0) {
                        this.searchCriteriaMap.put(CONTRACT_STAGE_KEY, contractSearchForm.getStage());
                    }
                    String attrValue = contractSearchForm.getAttrValue();
                    if (!contractSearchForm.getAttrId().isEmpty() && !attrValue.isEmpty()) {
                        this.searchCriteriaMap.put("attrId", contractSearchForm.getAttrId());
                        this.searchCriteriaMap.put("attrValue", attrValue);
                    }
                }
            }
        }
    }

    @Override
    public void applyMap(QueryCriteria query) {
        if (this.searchCriteriaMap == null) {
            return;
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_NON_EXPIRED_KEY)) {
            query.appendWhereClause("c.contract_expiration_date is null or c.contract_expiration_date>now()");
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_EXPIRED_KEY)) {
            query.appendWhereClause("c.contract_expiration_date < now()");
        }
        if (this.searchCriteriaMap.containsKey("contractNameContains")) {
            query.appendWhereClause("lower(c.contract_name) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("contractNameContains")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("contractTypeId")) {
            query.appendWhereClause("c.contract_type = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("contractTypeId")));
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_PROVIDER_ID_KEY)) {
            query.appendWhereClause("c.contract_provider_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTRACT_PROVIDER_ID_KEY)));
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_STAGE_KEY)) {
            query.appendWhereClause("c.contract_stage = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTRACT_STAGE_KEY)));
        }
        if (this.searchCriteriaMap.containsKey("description")) {
            query.appendWhereClause("lower(c.contract_description) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("description")) + "%')");
        }
        if (this.searchCriteriaMap.containsKey("attrId") && this.searchCriteriaMap.containsKey("attrValue")) {
            query.appendWhereClause("c.contract_id in (select object_id from object_attribute_value where attribute_id = " + SqlUtils.encodeInteger(this.searchCriteriaMap.get("attrId")) + " and lower(attr_value) like lower('%" + SqlUtils.encodeString(this.searchCriteriaMap.get("attrValue")) + "%'))");
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_EXPIRE_AFTER_KEY)) {
            query.appendWhereClause("c.contract_expiration_date > now()::timestamp + '+" + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTRACT_EXPIRE_AFTER_KEY)) + " day'::interval");
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_EXPIRE_BEFORE_KEY)) {
            query.appendWhereClause("c.contract_expiration_date < now()::timestamp + '+" + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTRACT_EXPIRE_BEFORE_KEY)) + " day'::interval");
        }
        if (this.searchCriteriaMap.containsKey(CONTRACT_EXPIRED_NOTIFIED_KEY)) {
            query.appendWhereClause("(c.contract_owner_id is not null)");
            query.appendWhereClause("(c.contract_expiration_notified is null or c.contract_expiration_notified <> " + SqlUtils.encodeInteger(this.searchCriteriaMap.get(CONTRACT_EXPIRED_NOTIFIED_KEY)) + ")");
        }
    }
}

