/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contracts.core;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.SystemUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.Callback;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ContractUtils {
    public static final String CONTACTS_TAB = "contactsTab";
    public static final String FILES_TAB = "filesTab";
    public static final String HARDWARE_TAB = "hardwareTab";
    public static final String[] CONTRACT_COLUMNS_DEFAULT = new String[]{"rownum", "contract_name", "contract_description", "contract_type", "contract_stage", "contract_owner", "contract_expiration_date", "contract_effective_date", "contract_renewal_type", "contract_renewal_date"};

    public static List<String> getSortableColumns() {
        return Arrays.asList("contract_name", "contract_id", "contract_owner", "contract_expiration_date", "contract_effective_date");
    }

    public static boolean isSortableColumn(String columnName) {
        return ContractUtils.getSortableColumns().contains(columnName);
    }

    public static List<String> getColumnHeaderList() {
        return Arrays.asList(ConfigManager.app.getContractsColumns());
    }

    public static String formatExpirationDate(RequestContext requestContext, Date currentDate, Date expirationDate) {
        return SystemUtils.formatExpirationDateHtml(requestContext, currentDate, expirationDate, ConfigManager.app.getContractsExpireCountdown());
    }

    public static String formatExpirationDateText(RequestContext requestContext, Date currentDate, Date expirationDate) {
        return SystemUtils.formatExpirationDateText(requestContext, currentDate, expirationDate, ConfigManager.app.getContractsExpireCountdown());
    }

    public static List<Link> contractTabList(RequestContext requestContext, Contract contract) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(requestContext);
        List<Integer> linkedTypes = Arrays.asList(ObjectTypes.HARDWARE, ObjectTypes.SOFTWARE);
        int relationshipCount = systemService.getLinkedObjectMapCount(linkedTypes, contract.getId(), ObjectTypes.CONTRACT);
        AccessUser user = requestContext.getUser();
        ArrayList<Link> tabList = new ArrayList<Link>();
        if (Access.hasPermission(user, AppPaths.CONTRACTS_DETAIL)) {
            tabList.add(new Link(requestContext).setName(FILES_TAB).setAjaxPath(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId()).setTitleKey("itMgmt.tab.contractFile"));
        }
        if (Access.hasPermission(user, AppPaths.CONTRACTS_ITEMS)) {
            tabList.add(new Link(requestContext).setName(HARDWARE_TAB).setAppPath(AppPaths.CONTRACTS_ITEMS + "?contractId=" + contract.getId()).setTitle(Localizer.getText(requestContext, "common.tab.relationships", new Object[]{relationshipCount})));
        }
        if (Access.hasPermission(user, AppPaths.CONTRACTS_CONTACTS)) {
            linkedTypes = Arrays.asList(ObjectTypes.CONTACT);
            int contactsCount = systemService.getLinkedObjectMapCount(linkedTypes, contract.getId(), ObjectTypes.CONTRACT);
            tabList.add(new Link(requestContext).setName(CONTACTS_TAB).setAppPath(AppPaths.CONTRACTS_CONTACTS + "?contractId=" + contract.getId()).setTitle(Localizer.getText(requestContext, "common.linking.tab.linkedContacts", new Object[]{contactsCount})));
        }
        return tabList;
    }

    public static List<DataRow> fetchContractList(final RequestContext requestContext, QueryCriteria queryCriteria, final Counter counter) throws Exception {
        AccessUser user = requestContext.getUser();
        final boolean hasContractAccess = Access.hasPermission(user, AppPaths.CONTRACTS_DETAIL);
        final boolean hasUserDetailAccess = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        final Date unixTimestamp = requestContext.getSysdate();
        final ArrayList<DataRow> list = new ArrayList<DataRow>();
        final List<String> columnHeaders = ContractUtils.getColumnHeaderList();
        ContractService contractService = ServiceProvider.getContractService(requestContext);
        queryCriteria.setCallback(new Callback(){

            @Override
            public void run(Object object) throws Exception {
                Contract contract = (Contract)object;
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("rownum")) {
                        columns.add(counter.incr() + ".");
                        continue;
                    }
                    if (column.equals("contract_name")) {
                        Link link = new Link(requestContext);
                        link.setTitle(contract.getName());
                        if (hasContractAccess) {
                            link.setAjaxPath(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
                        }
                        columns.add(link.getString());
                        continue;
                    }
                    if (column.equals("contract_description")) {
                        columns.add(HtmlUtils.formatMultiLineDisplay(contract.getDescription()));
                        continue;
                    }
                    if (column.equals("contract_type")) {
                        columns.add(HtmlUtils.encode(contract.getTypeName()));
                        continue;
                    }
                    if (column.equals("contract_stage")) {
                        columns.add(new AttributeManager(requestContext).getAttrFieldNameCache(Attributes.CONTRACT_STAGE, contract.getStage()));
                        continue;
                    }
                    if (column.equals("contract_owner")) {
                        AccessUser contractOwner = new CacheManager(requestContext).getUserCache(contract.getOwnerId());
                        columns.add(Links.getUserIconLink(requestContext, contractOwner, hasUserDetailAccess, true).getString());
                        continue;
                    }
                    if (column.equals("contract_renewal_type")) {
                        columns.add(HtmlUtils.encode(contract.getRenewalTypeName()));
                        continue;
                    }
                    if (column.equals("contract_expiration_date")) {
                        columns.add(ContractUtils.formatExpirationDate(requestContext, unixTimestamp, contract.getExpireDate()));
                        continue;
                    }
                    if (column.equals("contract_effective_date")) {
                        columns.add(DatetimeUtils.toShortDate(contract.getEffectiveDate()));
                        continue;
                    }
                    if (!column.equals("contract_renewal_date")) continue;
                    columns.add(DatetimeUtils.toShortDate(contract.getRenewalDate()));
                }
                DataRow dataRow = new DataRow();
                dataRow.setRowId(String.valueOf(contract.getId()));
                dataRow.setColumns(columns);
                list.add(dataRow);
            }
        });
        contractService.fetchContracts(queryCriteria);
        return list;
    }
}

