/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.contracts.dto;

import com.kwoksys.biz.base.BaseObject;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.Date;

public class Contract
extends BaseObject {
    public static final String ID = "contract_id";
    public static final String NAME = "contract_name";
    public static final String DESCRIPTION = "contract_description";
    public static final String TYPE = "contract_type";
    public static final String STAGE = "contract_stage";
    public static final String CONTRACT_OWNER_ID = "contract_owner_id";
    public static final String OWNER = "contract_owner";
    public static final String CONTRACT_OWNER_USERNAME = "contract_owner_username";
    public static final String CONTRACT_OWNER_DISPLAY_NAME = "contract_owner_display_name";
    public static final String CONTRACT_PROVIDER_ID = "contract_provider_id";
    public static final String CONTRACT_PROVIDER_NAME = "contract_provider_name";
    public static final String CONTRACT_EXPIRE_DATE = "contract_expiration_date";
    public static final String CONTRACT_EFFECT_DATE = "contract_effective_date";
    public static final String RENEWAL_TYPE = "contract_renewal_type";
    public static final String CONTRACT_RENEWAL_DATE = "contract_renewal_date";
    private Integer id;
    private String name;
    private String description;
    private Integer type = 0;
    private Integer stage = 0;
    private String typeName;
    private Date effectiveDate;
    private String effectiveDateDate = "";
    private String effectiveDateMonth = "";
    private String effectiveDateYear = "";
    private Date expireDate;
    private String expireDateDate = "";
    private String expireDateMonth = "";
    private String expireDateYear = "";
    private Integer renewalType = 0;
    private String renewalTypeName;
    private Date renewalDate;
    private String renewalDateDate = "";
    private String renewalDateMonth = "";
    private String renewalDateYear = "";
    private Integer contractProviderId = 0;
    private String contractProviderName;
    private Integer ownerId;
    private Integer contractProviderContactId;
    private String contractProviderContactName;

    public Contract() {
        super(ObjectTypes.CONTRACT);
    }

    public boolean hasContractEffectiveDate() {
        return !this.effectiveDateYear.isEmpty() || !this.effectiveDateMonth.isEmpty() || !this.effectiveDateDate.isEmpty();
    }

    public boolean isValidContractEffectiveDate() {
        return DatetimeUtils.isValidDate(this.effectiveDateYear, this.effectiveDateMonth, this.effectiveDateDate);
    }

    public boolean hasContractExpirationDate() {
        return !this.expireDateYear.isEmpty() || !this.expireDateMonth.isEmpty() || !this.expireDateDate.isEmpty();
    }

    public boolean isValidContractExpirationDate() {
        return DatetimeUtils.isValidDate(this.expireDateYear, this.expireDateMonth, this.expireDateDate);
    }

    public boolean hasContractRenewalDate() {
        return !this.renewalDateYear.isEmpty() || !this.renewalDateMonth.isEmpty() || !this.renewalDateDate.isEmpty();
    }

    public boolean isValidContractRenewalDate() {
        return DatetimeUtils.isValidDate(this.renewalDateYear, this.renewalDateMonth, this.renewalDateDate);
    }

    @Override
    public boolean isAttrEmpty(String attrName) {
        if (attrName.equals(TYPE)) {
            return this.type == 0;
        }
        if (attrName.equals(RENEWAL_TYPE)) {
            return this.renewalType == 0;
        }
        return false;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getRenewalType() {
        return this.renewalType;
    }

    public void setRenewalType(Integer renewalType) {
        this.renewalType = renewalType;
    }

    public Date getRenewalDate() {
        return this.renewalDate;
    }

    public void setRenewalDate(Date renewalDate) {
        this.renewalDate = renewalDate;
    }

    public String getEffectiveDateDate() {
        return this.effectiveDateDate;
    }

    public void setEffectiveDateDate(String effectiveDateDate) {
        this.effectiveDateDate = effectiveDateDate;
    }

    public String getEffectiveDateMonth() {
        return this.effectiveDateMonth;
    }

    public void setEffectiveDateMonth(String effectiveDateMonth) {
        this.effectiveDateMonth = effectiveDateMonth;
    }

    public String getEffectiveDateYear() {
        return this.effectiveDateYear;
    }

    public void setEffectiveDateYear(String effectiveDateYear) {
        this.effectiveDateYear = effectiveDateYear;
    }

    public String getExpireDateDate() {
        return this.expireDateDate;
    }

    public void setExpireDateDate(String expireDateDate) {
        this.expireDateDate = expireDateDate;
    }

    public String getExpireDateMonth() {
        return this.expireDateMonth;
    }

    public void setExpireDateMonth(String expireDateMonth) {
        this.expireDateMonth = expireDateMonth;
    }

    public String getExpireDateYear() {
        return this.expireDateYear;
    }

    public void setExpireDateYear(String expireDateYear) {
        this.expireDateYear = expireDateYear;
    }

    public String getRenewalDateDate() {
        return this.renewalDateDate;
    }

    public void setRenewalDateDate(String renewalDateDate) {
        this.renewalDateDate = renewalDateDate;
    }

    public String getRenewalDateMonth() {
        return this.renewalDateMonth;
    }

    public void setRenewalDateMonth(String renewalDateMonth) {
        this.renewalDateMonth = renewalDateMonth;
    }

    public String getRenewalDateYear() {
        return this.renewalDateYear;
    }

    public void setRenewalDateYear(String renewalDateYear) {
        this.renewalDateYear = renewalDateYear;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getRenewalTypeName() {
        return this.renewalTypeName;
    }

    public void setRenewalTypeName(String renewalTypeName) {
        this.renewalTypeName = renewalTypeName;
    }

    public Integer getContractProviderId() {
        return this.contractProviderId;
    }

    public void setContractProviderId(Integer contractProviderId) {
        this.contractProviderId = contractProviderId;
    }

    public String getContractProviderName() {
        return this.contractProviderName;
    }

    public void setContractProviderName(String contractProviderName) {
        this.contractProviderName = contractProviderName;
    }

    public Integer getContractProviderContactId() {
        return this.contractProviderContactId;
    }

    public void setContractProviderContactId(Integer contractProviderContactId) {
        this.contractProviderContactId = contractProviderContactId;
    }

    public String getContractProviderContactName() {
        return this.contractProviderContactName;
    }

    public void setContractProviderContactName(String contractProviderContactName) {
        this.contractProviderContactName = contractProviderContactName;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public Integer getStage() {
        return this.stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }
}

