/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.files;

import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.biz.files.dao.FileDao;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.HttpHelper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class FileService {
    private static final Logger LOGGER = Logger.getLogger(FileService.class.getName());
    private RequestContext requestContext;

    public FileService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public boolean isDirectoryExist(String directoryPath) {
        java.io.File file = new java.io.File(directoryPath);
        return file.isDirectory();
    }

    public boolean isFileExist(String filePath) {
        java.io.File file = new java.io.File(filePath);
        return file.isFile();
    }

    public List<File> getFiles(QueryCriteria query, Integer objectTypeId, Integer objectId) throws DatabaseException {
        FileDao fileDao = new FileDao(this.requestContext);
        return fileDao.getList(query, objectTypeId, objectId);
    }

    public File getFile(Integer objectTypeId, Integer objectId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileDao fileDao = new FileDao(this.requestContext);
        return fileDao.getFile(objectTypeId, objectId, fileId);
    }

    private ActionMessages upload(File file, FileUploadForm uploadForm) throws DatabaseException {
        UploadedFile[] files = uploadForm.getFiles();
        String[] fileNames = uploadForm.getFileNames();
        String[] mineTypes = uploadForm.getMineTypes();
        ActionMessages errors = new ActionMessages();
        if (files == null) {
            errors.add("file0", new ActionMessage("files.error.emptyFilePath"));
            return errors;
        }
        file.setLogicalName(fileNames[0]);
        file.setMimeType(mineTypes[0]);
        file.setSize(files[0].length().intValue());
        file.setAttachedFile(new java.io.File(files[0].getAbsolutePath()));
        if (file.getLogicalName().isEmpty()) {
            errors.add("file0", new ActionMessage("files.error.emptyFilePath"));
            return errors;
        }
        if ((long)file.getSize() > ConfigManager.file.getMaxFileUploadSize() || file.getSize() < 0) {
            errors.add("file0", new ActionMessage("files.error.fileMaxSize"));
            return errors;
        }
        FileDao fileDao = new FileDao(this.requestContext);
        try {
            errors = fileDao.add(file);
            if (!errors.isEmpty()) {
                return errors;
            }
            java.io.File uploadFile = new java.io.File(file.getConfigRepositoryPath(), file.getConfigUploadedFilePrefix() + file.getId());
            if (uploadFile.exists()) {
                throw new Exception("File already exists");
            }
            FileUtils.moveFile((java.io.File)file.getAttachedFile(), (java.io.File)uploadFile);
        }
        catch (Throwable t) {
            fileDao.deleteNew(file.getId());
            errors.add("fileUpload", new ActionMessage("files.error.fileUpload"));
            LOGGER.log(Level.SEVERE, "Problem writing file to repository. Original file name: " + file.getLogicalName() + ". Physical file name: " + file.getConfigUploadedFilePrefix() + file.getId() + ". File repository: " + file.getConfigRepositoryPath(), t);
        }
        return errors;
    }

    public ActionMessages addFile(File file, FileUploadForm actionForm) throws DatabaseException {
        ActionMessages errors = this.upload(file, actionForm);
        if (!errors.isEmpty()) {
            return errors;
        }
        file.setTitle(actionForm.getFileName0());
        file.setFileuploadedFileName(file.getConfigUploadedFilePrefix() + file.getId());
        FileDao fileDao = new FileDao(this.requestContext);
        errors = fileDao.update(file);
        if (!errors.isEmpty()) {
            return errors;
        }
        return errors;
    }

    public ActionMessages updateFile(File file, FileUploadForm actionForm) throws DatabaseException {
        FileDao fileDao = new FileDao(this.requestContext);
        file.setTitle(actionForm.getFileName0());
        ActionMessages errors = fileDao.updateTitle(file);
        if (!errors.isEmpty()) {
            return errors;
        }
        return errors;
    }

    private void deletePhysicalFile(String repositoryPath, String uploadedFileName) {
        java.io.File delfile = new java.io.File(repositoryPath, uploadedFileName);
        delfile.renameTo(new java.io.File(repositoryPath, ConfigManager.file.getDeleteFilePrefix() + uploadedFileName));
    }

    public ActionMessages deleteFile(File file) throws DatabaseException {
        FileDao fileDao = new FileDao(this.requestContext);
        ActionMessages errors = fileDao.delete(file);
        if (!errors.isEmpty()) {
            return errors;
        }
        this.deletePhysicalFile(file.getConfigRepositoryPath(), file.getPhysicalName());
        return errors;
    }

    public void bulkDelete(String configRepositoryPath, List<File> fileList) {
        for (File file : fileList) {
            this.deletePhysicalFile(configRepositoryPath, file.getPhysicalName());
        }
    }

    public void download(ResponseContext responseContext, File file) throws FileNotFoundException {
        HttpServletResponse response = responseContext.getResponse();
        response.setContentType(file.getMimeType());
        response.setContentLength(file.getSize());
        HttpHelper.setFilenameResponseHeaders(response, file.getLogicalName());
        java.io.File downloadFile = new java.io.File(file.getConfigRepositoryPath(), file.getPhysicalName());
        FileInputStream input = null;
        ServletOutputStream output = null;
        try {
            int read;
            input = new FileInputStream(downloadFile);
            output = response.getOutputStream();
            byte[] buffer = new byte[10240];
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.warning("Problem downloading a file: " + e.getMessage());
                throw new FileNotFoundException();
            }
            catch (Throwable throwable) {
                FileService.close(input);
                FileService.close(output);
                throw throwable;
            }
        }
        FileService.close(input);
        FileService.close((Closeable)output);
    }

    private static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

