/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.files.core;

import com.kwoksys.biz.system.core.Image;
import java.util.HashMap;
import java.util.Map;

public class FileTypeHelper {
    private static final Map<String, String> extMap = new HashMap<String, String>();

    public static String getExtImage(String fileTitle) {
        String ext = FileTypeHelper.parseExt(fileTitle)[1];
        String extImage = extMap.get(ext.toLowerCase());
        return Image.getInstance().getFileIcon(extImage == null ? "flaticon-file" : extImage);
    }

    public static String[] parseExt(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot == -1) {
            return new String[]{fileName, ""};
        }
        return new String[]{fileName.substring(0, lastDot), fileName.substring(lastDot + 1, fileName.length())};
    }

    static {
        extMap.put("csv", "flaticon-file_ext_csv");
        extMap.put("xls", "flaticon-file_ext_ms_excel");
        extMap.put("xlsx", "flaticon-file_ext_ms_excel");
        extMap.put("ppt", "flaticon-file_ext_ms_powerpoint");
        extMap.put("pptx", "flaticon-file_ext_ms_powerpoint");
        extMap.put("doc", "flaticon-file_ext_ms_word");
        extMap.put("docx", "flaticon-file_ext_ms_word");
        extMap.put("pdf", "flaticon-file_ext_pdf");
        extMap.put("gif", "flaticon-file_ext_image");
        extMap.put("jpg", "flaticon-file_ext_image");
        extMap.put("png", "flaticon-file_ext_image");
        extMap.put("rar", "flaticon-file_ext_rar");
        extMap.put("zip", "flaticon-file_ext_zip");
    }
}

