/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.files.core;

import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    public static final String CSV_EXTENSION = ".csv";
    public static final String PDF_EXTENSION = ".pdf";

    public static List<String> getFileColumnHeaders() {
        return Arrays.asList("rownum", "file_name", "file_friendly_name", "creation_date", "file_byte_size");
    }

    public static boolean isSortableColumn(String columnName) {
        return FileUtils.getSortableColumns().contains(columnName);
    }

    public static List<String> getSortableColumns() {
        return Arrays.asList("file_name", "file_friendly_name", "creation_date", "file_byte_size");
    }

    public static String formatFileSize(RequestContext requestContext, long fileSize) {
        String fileSizeString;
        DecimalFormat formatter;
        int kilobyteUnits = ConfigManager.file.getKilobyteUnits();
        String[] sizeIndex = new String[]{"bytes", "KB", "MB", "GB"};
        int logIndex = 0;
        if (fileSize >= (long)kilobyteUnits) {
            logIndex = (int)Math.floor(Math.log(fileSize) / Math.log(kilobyteUnits));
            if (logIndex > sizeIndex.length - 1) {
                logIndex = sizeIndex.length - 1;
            }
            formatter = new DecimalFormat("0.00");
            fileSizeString = formatter.format((double)fileSize / Math.pow(kilobyteUnits, logIndex));
        } else {
            formatter = new DecimalFormat("0");
            fileSizeString = formatter.format(fileSize);
        }
        Object[] args = new String[]{fileSizeString, Localizer.getText(requestContext, "files.colData.file_size." + sizeIndex[logIndex])};
        return Localizer.getText(requestContext, "files.colData.file_byte_size", args);
    }

    public static String fileToString(String path) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
    }
}

