/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.files.dao;

import com.kwoksys.biz.base.BaseDao;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.connections.database.QueryHelper;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.StringUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class FileDao
extends BaseDao {
    public FileDao(RequestContext requestContext) {
        super(requestContext);
    }

    public List<File> getList(QueryCriteria query, Integer objectTypeId, Integer objectId) throws DatabaseException {
        final ArrayList<File> files = new ArrayList<File>();
        QueryHelper queryHelper = new QueryHelper(FileQueries.selectFileListQuery(query)){

            @Override
            public void callback(ResultSet rs) throws Exception {
                File file = new File();
                file.setId(rs.getInt("file_id"));
                file.setLogicalName(StringUtils.replaceNull(rs.getString("file_name")));
                file.setTitle(StringUtils.replaceNull(rs.getString("file_friendly_name")));
                file.setDescription(StringUtils.replaceNull(rs.getString("file_description")));
                file.setMimeType(StringUtils.replaceNull(rs.getString("file_mime_type")));
                file.setSize(rs.getInt("file_byte_size"));
                file.setFileuploadedFileName(StringUtils.replaceNull(rs.getString("file_physical_name")));
                file.setCreationDate(DatetimeUtils.getDate(rs, "creation_date"));
                files.add(file);
            }
        };
        queryHelper.addInputInt(objectTypeId);
        queryHelper.addInputInt(objectId);
        this.executeQuery(queryHelper);
        return files;
    }

    public File getFile(final Integer objectTypeId, final Integer objectId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        final File file = new File();
        QueryHelper queryHelper = new QueryHelper(FileQueries.selectFileDetailQuery()){

            @Override
            public void callback(ResultSet rs) throws Exception {
                file.setObjectTypeId(objectTypeId);
                file.setObjectId(objectId);
                file.setId(rs.getInt("file_id"));
                file.setLogicalName(StringUtils.replaceNull(rs.getString("file_name")));
                file.setTitle(StringUtils.replaceNull(rs.getString("file_friendly_name")));
                file.setDescription(StringUtils.replaceNull(rs.getString("file_description")));
                file.setMimeType(StringUtils.replaceNull(rs.getString("file_mime_type")));
                file.setSize(rs.getInt("file_byte_size"));
                file.setFileuploadedFileName(StringUtils.replaceNull(rs.getString("file_physical_name")));
            }
        };
        queryHelper.addInputInt(objectTypeId);
        queryHelper.addInputInt(objectId);
        queryHelper.addInputInt(fileId);
        this.executeSingleRecordQuery(queryHelper);
        if (file.getId() != null) {
            return file;
        }
        throw new ObjectNotFoundException("File ID: " + fileId);
    }

    public ActionMessages add(File file) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(FileQueries.insertNewFileQuery());
        queryHelper.addOutputParam(4);
        queryHelper.addInputStringConvertNull(file.getTempFileName());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        this.executeProcedure(queryHelper);
        if (this.errors.isEmpty()) {
            file.setId((Integer)queryHelper.getSqlOutputs().get(0));
        }
        return this.errors;
    }

    public ActionMessages update(File file) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(FileQueries.updateNewFileDetailQuery());
        queryHelper.addInputInt(file.getId());
        queryHelper.addInputStringConvertNull(file.getLogicalName());
        queryHelper.addInputStringConvertNull(file.getTitle());
        queryHelper.addInputStringConvertNull(file.getDescription());
        queryHelper.addInputStringConvertNull(file.getMimeType());
        queryHelper.addInputInt(file.getSize());
        queryHelper.addInputStringConvertNull(file.getPhysicalName());
        queryHelper.addInputInt(file.getObjectTypeId());
        queryHelper.addInputInt(file.getObjectId());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages updateTitle(File file) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(FileQueries.updateFileDetailsQuery());
        queryHelper.addInputStringConvertNull(file.getTitle());
        queryHelper.addInputInt(this.requestContext.getUser().getId());
        queryHelper.addInputInt(file.getId());
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages deleteNew(Integer fileId) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(FileQueries.deleteNewfileQuery());
        queryHelper.addInputInt(fileId);
        return this.executeProcedure(queryHelper);
    }

    public ActionMessages delete(File file) throws DatabaseException {
        QueryHelper queryHelper = new QueryHelper(FileQueries.deleteFileQuery());
        queryHelper.addInputInt(file.getObjectTypeId());
        queryHelper.addInputInt(file.getObjectId());
        queryHelper.addInputInt(file.getId());
        return this.executeProcedure(queryHelper);
    }
}

