/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.biz.hardware;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.dao.HardwareDao;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.hardware.dto.HardwareComponent;
import com.kwoksys.biz.hardware.dto.HardwareSoftwareMap;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.Schema;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.linking.ContractHardwareLink;
import com.kwoksys.biz.system.dto.linking.HardwareIssueLink;
import com.kwoksys.biz.system.dto.linking.HardwareMemberLink;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.List;
import java.util.Map;

public class HardwareService {
    private RequestContext requestContext;

    public HardwareService(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public List<Hardware> getHardwareList(QueryCriteria queryCriteria) throws DatabaseException {
        return new HardwareDao(this.requestContext).getHardwareList(queryCriteria);
    }

    public List<Hardware> getLinkedHardwareList(QueryCriteria query, ObjectLink objectMap) throws DatabaseException {
        return new HardwareDao(this.requestContext).getLinkedHardwareList(query, objectMap);
    }

    public int getHardwareCount(QueryCriteria query) throws DatabaseException {
        return new HardwareDao(this.requestContext).getCount(query);
    }

    public Map<String, String> getWarrantyExpirationCounts() throws DatabaseException {
        return new HardwareDao(this.requestContext).getWarrantyExpirationCounts();
    }

    public List<AttributeFieldCount> getHardwareTypeCount(QueryCriteria query) throws DatabaseException {
        return new HardwareDao(this.requestContext).getHardwareTypeCount(query);
    }

    public List<AttributeFieldCount> getHardwareStatusCount(QueryCriteria query) throws DatabaseException {
        return new HardwareDao(this.requestContext).getHardwareStatusCount(query);
    }

    public List<AttributeFieldCount> getHardwareLocationCount(QueryCriteria query) throws DatabaseException {
        return new HardwareDao(this.requestContext).getHardwareLocationCount(query);
    }

    public Hardware getHardware(Integer hardwareId) throws DatabaseException, ObjectNotFoundException {
        return new HardwareDao(this.requestContext).getHardware(hardwareId);
    }

    public List<Hardware> getHardwareParents(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        HardwareMemberLink memberMap = new HardwareMemberLink();
        memberMap.setMemberHardwareId(hardwareId);
        return new HardwareDao(this.requestContext).getLinkedHardwareList(query, memberMap.createObjectMap());
    }

    public List<Hardware> getHardwareMembers(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        HardwareMemberLink memberMap = new HardwareMemberLink(hardwareId);
        return new HardwareDao(this.requestContext).getLinkedHardwareList(query, memberMap.createObjectMap());
    }

    public void fetchLinkedContracts(QueryCriteria queryCriteria, Integer hardwareId) throws DatabaseException {
        ContractHardwareLink contractMap = new ContractHardwareLink();
        contractMap.setHardwareId(hardwareId);
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        contractService.fetchLinkedContracts(queryCriteria, contractMap.createObjectMap());
    }

    public ActionMessages validateHardware(Hardware hardware, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validate(new ColumnField().setName("hardwareName").setTitleKey("common.column.hardware_name").setNullable(false).calculateLength(hardware.getName()).setColumnName("asset_hardware.hardware_name"));
        if (!errors.get("hardwareName").hasNext() && this.isDuplicatedHardwareName(hardware.getId(), hardware.getName())) {
            errors.add("hardwareName", new ActionMessage("itMgmt.hardwareAdd.error.nameDuplicated", hardware.getName()));
        }
        validator.validate(new ColumnField().setName("modelName").setTitleKey("common.column.hardware_model_name").calculateLength(hardware.getModelName()).setColumnName("asset_hardware.hardware_model_name"));
        validator.validate(new ColumnField().setName("modelNumber").setTitleKey("common.column.hardware_model_number").calculateLength(hardware.getModelNumber()).setColumnName("asset_hardware.hardware_model_number"));
        if (hardware.getSerialNumber().length() > Schema.getColumnLength("asset_hardware.hardware_serial_number")) {
            String fieldName = Localizer.getText(this.requestContext, "common.column.hardware_serial_number");
            errors.add("serialNumberMaxLength", new ActionMessage("common.form.fieldExceededMaxLen", new Object[]{fieldName, Schema.getColumnLength("asset_hardware.hardware_serial_number")}));
        } else if (this.validateDuplicatedHardwareSerialNumber(hardware)) {
            errors.add("duplicatedSerialNumber", new ActionMessage("itMgmt.hardwareAdd.error.duplicatedSerialNumber", new String[]{hardware.getSerialNumber()}));
        }
        if (!hardware.isValidHardwareCost()) {
            errors.add("hardwareCost", new ActionMessage("common.form.fieldFormatError", Localizer.getText(this.requestContext, "common.column.hardware_purchase_price")));
        }
        if (hardware.hasHardwarePurchaseDate() && !hardware.isValidPurchaseDate()) {
            errors.add("validPurchaseDateFormat", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.hardware_purchase_date")));
        }
        if (hardware.hasHardwareWarrantyExpireDate() && !hardware.isValidWarrantyExpireDate()) {
            errors.add("validWarrantyExpireDateFormat", new ActionMessage("common.form.fieldDateInvalid", Localizer.getText(this.requestContext, "common.column.hardware_warranty_expire_date")));
        }
        validator.validateAttrs(hardware, hardware.getType(), customAttributes);
        return errors;
    }

    public ActionMessages addHardware(Hardware hardware, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = this.validateHardware(hardware, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).addHardware(hardware);
    }

    public ActionMessages updateHardware(Hardware hardware, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = this.validateHardware(hardware, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).update(hardware);
    }

    public ActionMessages deleteHardware(Hardware hardware) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (hardware.getId() == 0) {
            errors.add("emptyHardwareId", new ActionMessage("itMgmt.hardwareEdit.error.emptyHardwareId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        List<File> deleteFileList = this.getHardwareFiles(new QueryCriteria(), hardware.getId());
        errors = new HardwareDao(this.requestContext).delete(hardware);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (errors.isEmpty()) {
            fileService.bulkDelete(ConfigManager.file.getHardwareFileRepositoryLocation(), deleteFileList);
        }
        return errors;
    }

    public List<Map<String, String>> getAvailableSoftware(QueryCriteria query) throws DatabaseException {
        return new HardwareDao(this.requestContext).getAvailableSoftware(query);
    }

    public List<SoftwareLicense> getAvailableLicenses(QueryCriteria query, Integer softwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).getAvailableLicense(query, softwareId);
    }

    public List<HardwareSoftwareMap> getInstalledLicense(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).getInstalledLicense(query, hardwareId);
    }

    public ActionMessages assignSoftwareLicense(HardwareSoftwareMap hsm) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (hsm.getHardwareId() == 0) {
            errors.add("emptyHardwareId", new ActionMessage("hardware.error.emptyHardwareId"));
        }
        if (hsm.getSoftwareId() == 0) {
            errors.add("emptySoftwareId", new ActionMessage("hardware.error.emptySoftwareId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).assignSoftwareLicense(hsm);
    }

    public ActionMessages unassignSoftwareLicense(HardwareSoftwareMap hsm) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (hsm.getMapId() == 0) {
            errors.add("emptyMapId", new ActionMessage("hardware.error.emptyMapId"));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).unassignSoftwareLicense(hsm);
    }

    public ActionMessages resetHardwareSoftwareCount(Integer hardwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).resetHardwareSoftwareCount(hardwareId);
    }

    public List<HardwareComponent> getHardwareComponents(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).getHardwareComponents(query, hardwareId);
    }

    public HardwareComponent getHardwareComponent(Integer hardwareId, Integer componentId) throws DatabaseException, ObjectNotFoundException {
        return new HardwareDao(this.requestContext).getHardwareComponentDetail(hardwareId, componentId);
    }

    public ActionMessages addHardwareComponent(HardwareComponent component, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        if (component.getType() == 0) {
            errors.add("hardwareComponentType", new ActionMessage("common.form.fieldRequired", Localizer.getText(this.requestContext, "common.column.hardware_component_type")));
        }
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validateAttrs(component, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).addHardwareComponent(component);
    }

    public ActionMessages updateHardwareComponent(HardwareComponent component, Map<Integer, Attribute> customAttributes) throws DatabaseException {
        ActionMessages errors = new ActionMessages();
        InputValidator validator = new InputValidator(this.requestContext, errors);
        validator.validateAttrs(component, customAttributes);
        if (!errors.isEmpty()) {
            return errors;
        }
        return new HardwareDao(this.requestContext).updateHardwareComponent(component);
    }

    public ActionMessages deleteHardwareComponent(HardwareComponent component) throws DatabaseException {
        return new HardwareDao(this.requestContext).deleteHardwareComponent(component);
    }

    public List<File> getHardwareFiles(QueryCriteria query, Integer hardwareId) throws DatabaseException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        return fileService.getFiles(query, ObjectTypes.HARDWARE, hardwareId);
    }

    public ActionMessages resetHardwareFileCount(Integer hardwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).resetFileCount(hardwareId);
    }

    public ActionMessages resetHardwareComponentCount(Integer hardwareId) throws DatabaseException {
        return new HardwareDao(this.requestContext).resetComponentCount(hardwareId);
    }

    public File getHardwareFile(Integer hardwareId, Integer fileId) throws DatabaseException, ObjectNotFoundException {
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        File file = fileService.getFile(ObjectTypes.HARDWARE, hardwareId, fileId);
        file.setConfigRepositoryPath(ConfigManager.file.getHardwareFileRepositoryLocation());
        file.setConfigUploadedFilePrefix(ConfigManager.file.getHardwareUploadedFilePrefix());
        return file;
    }

    public ActionMessages addHardwareIssue(HardwareIssueLink issueMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(issueMap.createObjectMap());
    }

    public ActionMessages deleteHardwareIssue(HardwareIssueLink issueMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(issueMap.createObjectMap());
    }

    public ActionMessages addHardwareMember(HardwareMemberLink memberMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.addObjectMapping(memberMap.createObjectMap());
    }

    public ActionMessages removeHardwareMember(HardwareMemberLink memberMap) throws DatabaseException {
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        return systemService.deleteObjectMapping(memberMap.createObjectMap());
    }

    public boolean isDuplicatedHardwareName(Integer hardwareId, String hardwareName) throws DatabaseException {
        if (ConfigManager.app.isCheckUniqueHardwareName()) {
            HardwareSearch hardwareSearch = new HardwareSearch();
            if (hardwareId != null) {
                hardwareSearch.put("hardwareIdNotEquals", hardwareId);
            }
            hardwareSearch.put("hardwareNameEquals", hardwareName);
            return this.getHardwareCount(new QueryCriteria(hardwareSearch)) > 0;
        }
        return false;
    }

    private boolean validateDuplicatedHardwareSerialNumber(Hardware hardware) throws DatabaseException {
        if (ConfigManager.app.isCheckUniqueSerialNumber()) {
            HardwareSearch hardwareSearch = new HardwareSearch();
            if (hardware.getId() != null) {
                hardwareSearch.put("hardwareIdNotEquals", hardware.getId());
            }
            hardwareSearch.put("manufacturerIdEquals", hardware.getManufacturerId());
            hardwareSearch.put("serialNumberEquals", hardware.getSerialNumber());
            return this.getHardwareCount(new QueryCriteria(hardwareSearch)) > 0;
        }
        return false;
    }

    public Hardware getSingleHardwareByName(String hardwareName) throws DatabaseException {
        HardwareSearch hardwareSearch = new HardwareSearch();
        hardwareSearch.put("hardwareNameEquals", hardwareName);
        QueryCriteria queryCriteria = new QueryCriteria(hardwareSearch);
        queryCriteria.setLimit(2, 0);
        List<Hardware> hardwareList = this.getHardwareList(queryCriteria);
        if (hardwareList.size() == 1) {
            return hardwareList.get(0);
        }
        return null;
    }
}

